/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.oid;

import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ObjectIdentifier
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private final byte[] encoded;

    private ObjectIdentifier() {
        this.encoded = null;
    }

    public ObjectIdentifier(byte[] bytes) {
        this.encoded = bytes;
    }

    public ObjectIdentifier(String id) {
        String[] splittedId = id.split("\\.");
        long[] idValues = new long[splittedId.length];
        try {
            int i = 0;
            while (i < splittedId.length) {
                idValues[i] = Long.parseLong(splittedId[i]);
                ++i;
            }
        }
        catch (RuntimeException E) {
            throw new ParserException("Could not parse OID '" + id + "'", (Throwable)E);
        }
        this.encoded = this.computeEncodedValue(idValues);
    }

    public ObjectIdentifier(long[] idValues) {
        this.encoded = this.computeEncodedValue(idValues);
    }

    private List<Long> decodeValue(byte[] content) {
        LinkedList<Long> resultList = new LinkedList<Long>();
        if (content.length > 0) {
            resultList.add(Long.valueOf(content[0] / 40));
            resultList.add(Long.valueOf(content[0] % 40));
            int contentPos = 1;
            while (contentPos < content.length) {
                boolean partFinished;
                long oidPart = 0L;
                do {
                    oidPart = oidPart << 7 | (long)(content[contentPos] & 0x7F);
                    boolean bl = partFinished = (content[contentPos] & 0x80) == 0;
                } while (++contentPos < content.length && !partFinished);
                resultList.add(oidPart);
            }
        }
        return resultList;
    }

    private byte[] computeEncodedValue(long[] idValues) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        if (idValues.length == 1) {
            stream.write((int)(idValues[0] * 40L));
        } else if (idValues.length >= 2) {
            stream.write((int)(idValues[0] * 40L + idValues[1]));
            int i = 2;
            while (i < idValues.length) {
                stream.write(this.encodeSingleIdValue(idValues[i]));
                ++i;
            }
        }
        return stream.toByteArray();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        List<Long> idValues = this.decodeValue(this.encoded);
        for (long idValue : idValues) {
            if (!first) {
                builder.append(".");
            } else {
                first = false;
            }
            builder.append(idValue);
        }
        return builder.toString();
    }

    public byte[] getEncoded() {
        return Arrays.copyOf(this.encoded, this.encoded.length);
    }

    private byte[] encodeSingleIdValue(long idValue) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        int moreFlag = 0;
        do {
            stream.write(new byte[]{(byte)((long)moreFlag | idValue & 0x7FL)});
            moreFlag = -128;
        } while ((idValue >>= 7) > 0L);
        return this.reverse(stream.toByteArray());
    }

    private byte[] reverse(byte[] array) {
        byte[] newArray = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            newArray[i] = array[array.length - (i + 1)];
            ++i;
        }
        return newArray;
    }
}

