/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.util;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.List;

public final class DataConverter {
    private DataConverter() {
    }

    public static byte[] longToUint64Bytes(long value) {
        byte[] result = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return result;
    }

    public static byte[] longToUint48Bytes(long value) {
        byte[] output = new byte[]{(byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return output;
    }

    public static byte[] longToUint32Bytes(long value) {
        byte[] result = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return result;
    }

    public static long uInt64BytesToLong(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Input byte array must not be null");
        }
        if (bytes.length != 8) {
            throw new IllegalArgumentException("Input byte array must be exactly 8 bytes long");
        }
        return (long)(bytes[0] & 0xFF) << 56 | (long)(bytes[1] & 0xFF) << 48 | (long)(bytes[2] & 0xFF) << 40 | (long)(bytes[3] & 0xFF) << 32 | (long)(bytes[4] & 0xFF) << 24 | (long)(bytes[5] & 0xFF) << 16 | (long)(bytes[6] & 0xFF) << 8 | (long)(bytes[7] & 0xFF);
    }

    public static long uInt32BytesToLong(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Input byte array must not be null");
        }
        if (bytes.length != 4) {
            throw new IllegalArgumentException("Input byte array must be exactly 4 bytes long");
        }
        return (long)(bytes[0] & 0xFF) << 24 | (long)((bytes[1] & 0xFF) << 16) | (long)((bytes[2] & 0xFF) << 8) | (long)(bytes[3] & 0xFF);
    }

    public static byte[] intToBytes(int value, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("The array must be at least of size 1");
        }
        byte[] result = new byte[size];
        int shift = 0;
        int finalPosition = size > 4 ? size - 4 : 0;
        for (int i = size - 1; i >= finalPosition; --i) {
            result[i] = (byte)(value >>> shift);
            shift += 8;
        }
        return result;
    }

    public static byte[] longToBytes(long value, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("The array must be at least of size 1");
        }
        byte[] result = new byte[size];
        int shift = 0;
        int finalPosition = size > 8 ? size - 8 : 0;
        for (int i = size - 1; i >= finalPosition; --i) {
            result[i] = (byte)(value >>> shift);
            shift += 8;
        }
        return result;
    }

    public static int bytesToInt(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("Input byte array must not be null");
        }
        if (value.length > 4) {
            throw new IllegalArgumentException("Input byte array length must not exceed 4 bytes");
        }
        int result = 0;
        int shift = 0;
        for (int i = value.length - 1; i >= 0; --i) {
            result += (value[i] & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }

    public static long bytesToLong(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("Input byte array must not be null");
        }
        if (value.length > 8) {
            throw new IllegalArgumentException("Input byte array length must not exceed 8 bytes");
        }
        long result = 0L;
        int shift = 0;
        for (int i = value.length - 1; i >= 0; --i) {
            result += (long)(value[i] & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }

    public static String bytesToHexString(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Input byte array must not be null");
        }
        boolean usePrettyPrinting = array.length > 15;
        return DataConverter.bytesToHexString(array, usePrettyPrinting);
    }

    public static String bytesToHexString(byte[] array, boolean usePrettyPrinting) {
        if (array == null) {
            throw new IllegalArgumentException("Input byte array must not be null");
        }
        return DataConverter.bytesToHexString(array, usePrettyPrinting, true);
    }

    public static String bytesToHexString(byte[] array, boolean usePrettyPrinting, boolean initialNewLine) {
        if (array == null) {
            throw new IllegalArgumentException("Input byte array must not be null");
        }
        StringBuilder result = new StringBuilder();
        if (initialNewLine && usePrettyPrinting) {
            result.append("\n");
        }
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                if (usePrettyPrinting && i % 16 == 0) {
                    result.append("\n");
                } else {
                    if (usePrettyPrinting && i % 8 == 0) {
                        result.append(" ");
                    }
                    result.append(" ");
                }
            }
            byte b = array[i];
            result.append(String.format("%02X", b));
        }
        return result.toString();
    }

    public static String bytesToHexString(ModifiableByteArray array) {
        if (array == null) {
            throw new IllegalArgumentException("Input ModifiableByteArray must not be null");
        }
        byte[] value = (byte[])array.getValue();
        if (value == null) {
            throw new IllegalArgumentException("Value of ModifiableByteArray must not be null");
        }
        return DataConverter.bytesToHexString(value);
    }

    public static String bytesToHexString(ModifiableByteArray array, boolean usePrettyPrinting) {
        if (array == null) {
            throw new IllegalArgumentException("Input ModifiableByteArray must not be null");
        }
        byte[] value = (byte[])array.getValue();
        if (value == null) {
            throw new IllegalArgumentException("Value of ModifiableByteArray must not be null");
        }
        return DataConverter.bytesToHexString(value, usePrettyPrinting, true);
    }

    public static String bytesToHexString(ModifiableByteArray array, boolean usePrettyPrinting, boolean initialNewLine) {
        if (array == null) {
            throw new IllegalArgumentException("Input ModifiableByteArray must not be null");
        }
        byte[] value = (byte[])array.getValue();
        if (value == null) {
            throw new IllegalArgumentException("Value of ModifiableByteArray must not be null");
        }
        return DataConverter.bytesToHexString(value, usePrettyPrinting, initialNewLine);
    }

    public static String bytesToRawHexString(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Input byte array must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (byte b : array) {
            result.append(String.format("%02X", b));
        }
        return result.toString();
    }

    @SafeVarargs
    public static <T> T[] concatenate(T[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new IllegalArgumentException("The minimal number of parameters for this function is one");
        }
        int length = 0;
        for (T[] a : arrays) {
            if (a == null) {
                throw new IllegalArgumentException("Input arrays must not be null");
            }
            length += a.length;
        }
        Object[] result = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), length);
        int currentOffset = 0;
        for (T[] a : arrays) {
            System.arraycopy(a, 0, result, currentOffset, a.length);
            currentOffset += a.length;
        }
        return result;
    }

    public static byte[] concatenate(byte[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new IllegalArgumentException("The minimal number of parameters for this function is one");
        }
        int length = 0;
        for (byte[] a : arrays) {
            if (a == null) {
                throw new IllegalArgumentException("Input arrays must not be null");
            }
            length += a.length;
        }
        byte[] result = new byte[length];
        int currentOffset = 0;
        for (byte[] a : arrays) {
            System.arraycopy(a, 0, result, currentOffset, a.length);
            currentOffset += a.length;
        }
        return result;
    }

    public static byte[] concatenate(byte[] array1, byte[] array2, int numberOfArray2Bytes) {
        if (array1 == null) {
            throw new IllegalArgumentException("First array must not be null");
        }
        if (array2 == null) {
            throw new IllegalArgumentException("Second array must not be null");
        }
        if (numberOfArray2Bytes < 0 || numberOfArray2Bytes > array2.length) {
            throw new IllegalArgumentException("Number of bytes from second array must be between 0 and array2.length");
        }
        int length = array1.length + numberOfArray2Bytes;
        byte[] result = new byte[length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, numberOfArray2Bytes);
        return result;
    }

    public static void makeArrayNonZero(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Input array must not be null");
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != 0) continue;
            array[i] = 1;
        }
    }

    public static byte[] bigIntegerToByteArray(BigInteger value, int expectedLength, boolean removeSignByte) {
        byte[] tmp;
        if (value == null) {
            throw new IllegalArgumentException("Input BigInteger must not be null");
        }
        if (expectedLength == 0) {
            return new byte[0];
        }
        if (value.equals(BigInteger.ZERO)) {
            return new byte[expectedLength];
        }
        byte[] array = value.toByteArray();
        int remainder = array.length % expectedLength;
        byte[] result = array;
        if (removeSignByte && result[0] == 0) {
            tmp = new byte[result.length - 1];
            System.arraycopy(result, 1, tmp, 0, tmp.length);
            result = tmp;
            remainder = tmp.length % expectedLength;
        }
        if (remainder > 0) {
            tmp = new byte[result.length + expectedLength - remainder];
            System.arraycopy(result, 0, tmp, expectedLength - remainder, result.length);
            result = tmp;
        }
        return result;
    }

    public static byte[] bigIntegerToByteArray(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException("Input BigInteger must not be null");
        }
        if (value.equals(BigInteger.ZERO)) {
            return new byte[0];
        }
        byte[] result = value.toByteArray();
        if (result.length > 1 && result[0] == 0) {
            byte[] tmp = new byte[result.length - 1];
            System.arraycopy(result, 1, tmp, 0, tmp.length);
            result = tmp;
        }
        return result;
    }

    public static BigInteger[] convertListToArray(List<BigInteger> list) {
        if (list == null) {
            throw new IllegalArgumentException("Input list must not be null");
        }
        BigInteger[] result = new BigInteger[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static byte[] hexStringToByteArray(String input) {
        if (input == null || input.length() % 2 != 0) {
            throw new IllegalArgumentException("The input must not be null and shall have an even number of hexadecimal characters. Found: " + input);
        }
        byte[] output = new byte[input.length() / 2];
        for (int i = 0; i < output.length; ++i) {
            output[i] = (byte)((Character.digit(input.charAt(i * 2), 16) << 4) + Character.digit(input.charAt(i * 2 + 1), 16));
        }
        return output;
    }

    public static byte[] bigIntegerToNullPaddedByteArray(BigInteger input, int outputSizeInBytes) {
        int i;
        int remainingBits;
        if (input == null) {
            throw new IllegalArgumentException("'input' must not be null.");
        }
        byte[] output = new byte[outputSizeInBytes];
        int numByteBlocks = input.bitLength() / 8;
        if (numByteBlocks < output.length) {
            remainingBits = input.bitLength() % 8;
        } else {
            remainingBits = 0;
            numByteBlocks = output.length;
        }
        for (i = 0; i < numByteBlocks; ++i) {
            output[output.length - 1 - i] = input.shiftRight(i * 8).byteValue();
        }
        if (remainingBits > 0) {
            output[output.length - 1 - i] = input.shiftRight(i * 8).byteValue();
        }
        return output;
    }

    public static byte[] reverseByteOrder(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Input array must not be null");
        }
        int length = array.length;
        byte[] temp = new byte[length];
        int counter = length - 1;
        for (int i = 0; i < length; ++i) {
            temp[i] = array[counter--];
        }
        return temp;
    }

    public static Integer indexOf(byte[] outerArray, byte[] innerArray) {
        if (outerArray == null) {
            throw new IllegalArgumentException("Outer array must not be null");
        }
        if (innerArray == null) {
            throw new IllegalArgumentException("Inner array must not be null");
        }
        if (innerArray.length == 0) {
            throw new IllegalArgumentException("Inner array must not be empty");
        }
        if (innerArray.length > outerArray.length) {
            return null;
        }
        for (int i = 0; i < outerArray.length - innerArray.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < innerArray.length; ++j) {
                if (outerArray[i + j] == innerArray[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return null;
    }

    public static int byteToUnsignedInt(byte b) {
        return b & 0xFF;
    }
}

