/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.chooser;

import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.EllipticCurveType;
import de.rub.nds.tlsattacker.core.constants.EsniDnsKeyRecordVersion;
import de.rub.nds.tlsattacker.core.constants.GOSTCurve;
import de.rub.nds.tlsattacker.core.constants.HeartbeatMode;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.SrtpProtectionProfile;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.constants.TokenBindingVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EchConfig;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.KeyShareEntryPreparator;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bouncycastle.util.Arrays;

public class DefaultChooser
extends Chooser {
    DefaultChooser(Context context, Config config) {
        super(context, config);
    }

    @Override
    public CertificateType getSelectedClientCertificateType() {
        if (this.context.getTlsContext().getSelectedClientCertificateType() != null) {
            return this.context.getTlsContext().getSelectedClientCertificateType();
        }
        return this.config.getDefaultSelectedClientCertificateType();
    }

    @Override
    public CertificateType getSelectedServerCertificateType() {
        if (this.context.getTlsContext().getSelectedServerCertificateType() != null) {
            return this.context.getTlsContext().getSelectedServerCertificateType();
        }
        return this.config.getDefaultSelectedServerCertificateType();
    }

    @Override
    public List<ECPointFormat> getClientSupportedPointFormats() {
        if (this.context.getTlsContext().getClientPointFormatsList() != null) {
            return this.context.getTlsContext().getClientPointFormatsList();
        }
        return this.config.getDefaultClientSupportedPointFormats();
    }

    @Override
    public SignatureAndHashAlgorithm getSelectedSigHashAlgorithm() {
        if (this.context.getTlsContext().getSelectedSignatureAndHashAlgorithm() != null) {
            return this.context.getTlsContext().getSelectedSignatureAndHashAlgorithm();
        }
        return this.config.getDefaultSelectedSignatureAndHashAlgorithm();
    }

    @Override
    public List<NamedGroup> getClientSupportedNamedGroups() {
        if (this.context.getTlsContext().getClientNamedGroupsList() != null) {
            return this.context.getTlsContext().getClientNamedGroupsList();
        }
        return this.config.getDefaultClientNamedGroups();
    }

    @Override
    public List<NamedGroup> getServerSupportedNamedGroups() {
        if (this.context.getTlsContext().getServerNamedGroupsList() != null) {
            return this.context.getTlsContext().getServerNamedGroupsList();
        }
        return this.config.getDefaultServerNamedGroups();
    }

    @Override
    public List<ECPointFormat> getServerSupportedPointFormats() {
        if (this.context.getTlsContext().getServerPointFormatsList() != null) {
            return this.context.getTlsContext().getServerPointFormatsList();
        }
        return this.config.getDefaultServerSupportedPointFormats();
    }

    @Override
    public List<SignatureAndHashAlgorithm> getClientSupportedSignatureAndHashAlgorithms() {
        if (this.context.getTlsContext().getClientSupportedSignatureAndHashAlgorithms() != null) {
            return this.context.getTlsContext().getClientSupportedSignatureAndHashAlgorithms();
        }
        return this.config.getDefaultClientSupportedSignatureAndHashAlgorithms();
    }

    @Override
    public List<SignatureAndHashAlgorithm> getClientSupportedCertificateSignAlgorithms() {
        if (this.context.getTlsContext().getClientSupportedCertificateSignAlgorithms() != null) {
            return this.context.getTlsContext().getClientSupportedCertificateSignAlgorithms();
        }
        return this.config.getDefaultClientSupportedCertificateSignAlgorithms();
    }

    @Override
    public ProtocolVersion getLastRecordVersion() {
        if (this.context.getTlsContext().getLastRecordVersion() != null) {
            return this.context.getTlsContext().getLastRecordVersion();
        }
        return this.config.getDefaultLastRecordProtocolVersion();
    }

    @Override
    public byte[] getDistinguishedNames() {
        if (this.context.getTlsContext().getDistinguishedNames() != null) {
            return this.copy(this.context.getTlsContext().getDistinguishedNames());
        }
        return this.config.getDistinguishedNames();
    }

    @Override
    public List<ClientCertificateType> getClientCertificateTypes() {
        if (this.context.getTlsContext().getClientCertificateTypes() != null) {
            return this.context.getTlsContext().getClientCertificateTypes();
        }
        return this.config.getClientCertificateTypes();
    }

    @Override
    public HeartbeatMode getHeartbeatMode() {
        if (this.context.getTlsContext().getHeartbeatMode() != null) {
            return this.context.getTlsContext().getHeartbeatMode();
        }
        return this.config.getDefaultHeartbeatMode();
    }

    @Override
    public boolean isUseExtendedMasterSecret() {
        return this.context.getTlsContext().isUseExtendedMasterSecret();
    }

    @Override
    public List<CompressionMethod> getClientSupportedCompressions() {
        if (this.context.getTlsContext().getClientSupportedCompressions() != null) {
            return this.context.getTlsContext().getClientSupportedCompressions();
        }
        return this.config.getDefaultClientSupportedCompressionMethods();
    }

    @Override
    public List<CipherSuite> getClientSupportedCipherSuites() {
        if (this.context.getTlsContext().getClientSupportedCipherSuites() != null) {
            return this.context.getTlsContext().getClientSupportedCipherSuites();
        }
        return this.config.getDefaultClientSupportedCipherSuites();
    }

    @Override
    public List<SignatureAndHashAlgorithm> getServerSupportedSignatureAndHashAlgorithms() {
        if (this.context.getTlsContext().getServerSupportedSignatureAndHashAlgorithms() != null) {
            return this.context.getTlsContext().getServerSupportedSignatureAndHashAlgorithms();
        }
        return this.config.getDefaultServerSupportedSignatureAndHashAlgorithms();
    }

    @Override
    public List<SignatureAndHashAlgorithm> getServerSupportedCertificateSignAlgorithms() {
        if (this.context.getTlsContext().getServerSupportedCertificateSignAlgorithms() != null) {
            return this.context.getTlsContext().getServerSupportedCertificateSignAlgorithms();
        }
        return this.config.getDefaultServerSupportedCertificateSignAlgorithms();
    }

    @Override
    public ProtocolVersion getSelectedProtocolVersion() {
        if (this.context.getTlsContext().getSelectedProtocolVersion() != null) {
            return this.context.getTlsContext().getSelectedProtocolVersion();
        }
        return this.config.getDefaultSelectedProtocolVersion();
    }

    @Override
    public ProtocolVersion getHighestClientProtocolVersion() {
        if (this.context.getTlsContext().getHighestClientProtocolVersion() != null) {
            return this.context.getTlsContext().getHighestClientProtocolVersion();
        }
        return this.config.getDefaultHighestClientProtocolVersion();
    }

    @Override
    public ConnectionEndType getTalkingConnectionEnd() {
        return this.context.getTlsContext().getTalkingConnectionEndType();
    }

    @Override
    public byte[] getMasterSecret() {
        if (this.context.getTlsContext().getMasterSecret() != null) {
            return this.copy(this.context.getTlsContext().getMasterSecret());
        }
        return this.config.getDefaultMasterSecret();
    }

    @Override
    public CipherSuite getSelectedCipherSuite() {
        if (this.context.getTlsContext().getSelectedCipherSuite() != null) {
            return this.context.getTlsContext().getSelectedCipherSuite();
        }
        return this.config.getDefaultSelectedCipherSuite();
    }

    @Override
    public SSL2CipherSuite getSSL2CipherSuite() {
        if (this.context.getTlsContext().getSSL2CipherSuite() != null) {
            return this.context.getTlsContext().getSSL2CipherSuite();
        }
        return this.config.getDefaultSSL2CipherSuite();
    }

    @Override
    public byte[] getPreMasterSecret() {
        if (this.context.getTlsContext().getPreMasterSecret() != null) {
            return this.copy(this.context.getTlsContext().getPreMasterSecret());
        }
        return this.config.getDefaultPreMasterSecret();
    }

    @Override
    public byte[] getClientRandom() {
        if (this.context.getTlsContext().getClientRandom() != null) {
            return this.copy(this.context.getTlsContext().getClientRandom());
        }
        return this.config.getDefaultClientRandom();
    }

    @Override
    public ClientHelloMessage getInnerClientHello() {
        if (this.context.getTlsContext().getInnerClientHello() != null) {
            return this.context.getTlsContext().getInnerClientHello();
        }
        return new ClientHelloMessage();
    }

    @Override
    public byte[] getClientExtendedRandom() {
        if (this.context.getTlsContext().getClientExtendedRandom() != null) {
            return this.copy(this.context.getTlsContext().getClientExtendedRandom());
        }
        return this.config.getDefaultClientExtendedRandom();
    }

    @Override
    public byte[] getServerExtendedRandom() {
        if (this.context.getTlsContext().getServerExtendedRandom() != null) {
            return this.copy(this.context.getTlsContext().getServerExtendedRandom());
        }
        return this.config.getDefaultServerExtendedRandom();
    }

    @Override
    public byte[] getServerRandom() {
        if (this.context.getTlsContext().getServerRandom() != null) {
            return this.copy(this.context.getTlsContext().getServerRandom());
        }
        return this.config.getDefaultServerRandom();
    }

    @Override
    public CompressionMethod getSelectedCompressionMethod() {
        if (this.context.getTlsContext().getSelectedCompressionMethod() != null) {
            return this.context.getTlsContext().getSelectedCompressionMethod();
        }
        return this.config.getDefaultSelectedCompressionMethod();
    }

    @Override
    public byte[] getClientSessionId() {
        if (this.context.getTlsContext().getClientSessionId() != null) {
            return this.copy(this.context.getTlsContext().getClientSessionId());
        }
        return this.config.getDefaultClientSessionId();
    }

    @Override
    public byte[] getServerSessionId() {
        if (this.context.getTlsContext().getServerSessionId() != null) {
            return this.copy(this.context.getTlsContext().getServerSessionId());
        }
        return this.config.getDefaultServerSessionId();
    }

    @Override
    public byte[] getDtlsCookie() {
        if (this.context.getTlsContext().getDtlsCookie() != null) {
            return this.copy(this.context.getTlsContext().getDtlsCookie());
        }
        return this.config.getDtlsDefaultCookie();
    }

    @Override
    public TransportHandler getTransportHandler() {
        return this.context.getTransportHandler();
    }

    @Override
    public PRFAlgorithm getPRFAlgorithm() {
        if (this.context.getTlsContext().getPrfAlgorithm() != null) {
            return this.context.getTlsContext().getPrfAlgorithm();
        }
        return this.config.getDefaultPRFAlgorithm();
    }

    @Override
    public byte[] getLatestSessionTicket() {
        if (this.context.getTlsContext().getLatestSessionTicket() != null) {
            return this.context.getTlsContext().getLatestSessionTicket();
        }
        return this.config.getTlsSessionTicket();
    }

    @Override
    public byte[] getSignedCertificateTimestamp() {
        if (this.context.getTlsContext().getSignedCertificateTimestamp() != null) {
            return this.copy(this.context.getTlsContext().getSignedCertificateTimestamp());
        }
        return this.config.getDefaultSignedCertificateTimestamp();
    }

    @Override
    public TokenBindingVersion getTokenBindingVersion() {
        if (this.context.getTlsContext().getTokenBindingVersion() != null) {
            return this.context.getTlsContext().getTokenBindingVersion();
        }
        return this.config.getDefaultTokenBindingVersion();
    }

    @Override
    public List<TokenBindingKeyParameters> getTokenBindingKeyParameters() {
        if (this.context.getTlsContext().getTokenBindingKeyParameters() != null) {
            return this.context.getTlsContext().getTokenBindingKeyParameters();
        }
        return this.config.getDefaultTokenBindingKeyParameters();
    }

    @Override
    public BigInteger getSRPModulus() {
        if (this.context.getTlsContext().getSRPModulus() != null) {
            return this.context.getTlsContext().getSRPModulus();
        }
        return this.config.getDefaultSRPModulus();
    }

    @Override
    public byte[] getPSKIdentity() {
        if (this.context.getTlsContext().getPSKIdentity() != null) {
            return this.copy(this.context.getTlsContext().getPSKIdentity());
        }
        return this.config.getDefaultPSKIdentity();
    }

    @Override
    public byte[] getPSKIdentityHint() {
        if (this.context.getTlsContext().getPSKIdentityHint() != null) {
            return this.copy(this.context.getTlsContext().getPSKIdentityHint());
        }
        return this.config.getDefaultPSKIdentityHint();
    }

    @Override
    public BigInteger getSRPGenerator() {
        if (this.context.getTlsContext().getSRPGenerator() != null) {
            return this.context.getTlsContext().getSRPGenerator();
        }
        return this.config.getDefaultSRPGenerator();
    }

    @Override
    public BigInteger getSRPServerPrivateKey() {
        if (this.context.getTlsContext().getServerSRPPrivateKey() != null) {
            return this.context.getTlsContext().getServerSRPPrivateKey();
        }
        return this.config.getDefaultSRPServerPrivateKey();
    }

    @Override
    public BigInteger getSRPServerPublicKey() {
        if (this.context.getTlsContext().getServerSRPPublicKey() != null) {
            return this.context.getTlsContext().getServerSRPPublicKey();
        }
        return this.config.getDefaultSRPServerPublicKey();
    }

    @Override
    public BigInteger getSRPClientPrivateKey() {
        if (this.context.getTlsContext().getClientSRPPrivateKey() != null) {
            return this.context.getTlsContext().getClientSRPPrivateKey();
        }
        return this.config.getDefaultSRPClientPrivateKey();
    }

    @Override
    public BigInteger getSRPClientPublicKey() {
        if (this.context.getTlsContext().getClientSRPPublicKey() != null) {
            return this.context.getTlsContext().getClientSRPPublicKey();
        }
        return this.config.getDefaultSRPClientPublicKey();
    }

    @Override
    public byte[] getSRPPassword() {
        if (this.context.getTlsContext().getSRPPassword() != null) {
            return this.copy(this.context.getTlsContext().getSRPPassword());
        }
        return this.config.getDefaultSRPPassword();
    }

    @Override
    public byte[] getSRPIdentity() {
        if (this.context.getTlsContext().getSRPIdentity() != null) {
            return this.copy(this.context.getTlsContext().getSRPIdentity());
        }
        return this.config.getDefaultSRPIdentity();
    }

    @Override
    public byte[] getSRPServerSalt() {
        if (this.context.getTlsContext().getSRPServerSalt() != null) {
            return this.copy(this.context.getTlsContext().getSRPServerSalt());
        }
        return this.config.getDefaultSRPServerSalt();
    }

    @Override
    public GOSTCurve getSelectedGostCurve() {
        if (this.context.getTlsContext().getSelectedGostCurve() != null) {
            return this.context.getTlsContext().getSelectedGostCurve();
        }
        return this.config.getDefaultSelectedGostCurve();
    }

    @Override
    public NamedGroup getSelectedNamedGroup() {
        if (this.context.getTlsContext().getSelectedGroup() != null) {
            return this.context.getTlsContext().getSelectedGroup();
        }
        return this.config.getDefaultSelectedNamedGroup();
    }

    @Override
    public EllipticCurveType getEcCurveType() {
        return EllipticCurveType.NAMED_CURVE;
    }

    @Override
    public byte[] getCertificateRequestContext() {
        if (this.context.getTlsContext().getCertificateRequestContext() != null) {
            return this.copy(this.context.getTlsContext().getCertificateRequestContext());
        }
        return this.config.getDefaultCertificateRequestContext();
    }

    @Override
    public byte[] getServerHandshakeTrafficSecret() {
        if (this.context.getTlsContext().getServerHandshakeTrafficSecret() != null) {
            return this.copy(this.context.getTlsContext().getServerHandshakeTrafficSecret());
        }
        return this.config.getDefaultServerHandshakeTrafficSecret();
    }

    @Override
    public byte[] getClientHandshakeTrafficSecret() {
        if (this.context.getTlsContext().getClientHandshakeTrafficSecret() != null) {
            return this.copy(this.context.getTlsContext().getClientHandshakeTrafficSecret());
        }
        return this.config.getDefaultClientHandshakeTrafficSecret();
    }

    @Override
    public byte[] getClientApplicationTrafficSecret() {
        if (this.context.getTlsContext().getClientApplicationTrafficSecret() != null) {
            return this.copy(this.context.getTlsContext().getClientApplicationTrafficSecret());
        }
        return this.config.getDefaultClientApplicationTrafficSecret();
    }

    @Override
    public byte[] getServerApplicationTrafficSecret() {
        if (this.context.getTlsContext().getServerApplicationTrafficSecret() != null) {
            return this.copy(this.context.getTlsContext().getServerApplicationTrafficSecret());
        }
        return this.config.getDefaultServerApplicationTrafficSecret();
    }

    @Override
    public Connection getConnection() {
        return this.context.getConnection();
    }

    @Override
    public ConnectionEndType getMyConnectionPeer() {
        return this.getConnection().getLocalConnectionEndType() == ConnectionEndType.CLIENT ? ConnectionEndType.SERVER : ConnectionEndType.CLIENT;
    }

    @Override
    public ProtocolVersion getHighestProtocolVersion() {
        if (this.context.getTlsContext().getHighestProtocolVersion() != null) {
            return this.context.getTlsContext().getHighestProtocolVersion();
        }
        return this.config.getHighestProtocolVersion();
    }

    @Override
    public boolean isClientAuthentication() {
        if (this.context.getTlsContext().isClientAuthentication() != null) {
            return this.context.getTlsContext().isClientAuthentication();
        }
        return this.config.isClientAuthentication();
    }

    @Override
    public byte[] getLastHandledApplicationMessageData() {
        if (this.context.getTlsContext().getLastHandledApplicationMessageData() != null) {
            return this.copy(this.context.getTlsContext().getLastHandledApplicationMessageData());
        }
        return this.config.getDefaultApplicationMessageData().getBytes(StandardCharsets.ISO_8859_1);
    }

    @Override
    public byte[] getPsk() {
        if (this.context.getTlsContext().getPsk() != null) {
            return this.copy(this.context.getTlsContext().getPsk());
        }
        return this.config.getPsk();
    }

    @Override
    public String getHttpCookieValue() {
        String cookieVal = this.context.getHttpContext().getHttpCookieValue();
        if (cookieVal != null && !cookieVal.isEmpty()) {
            return cookieVal;
        }
        return this.config.getDefaultHttpCookieValue();
    }

    @Override
    public String getHttpCookieName() {
        String cookieName = this.context.getHttpContext().getHttpCookieName();
        if (cookieName != null && !cookieName.isEmpty()) {
            return cookieName;
        }
        return this.config.getDefaultHttpCookieName();
    }

    @Override
    public List<PskSet> getPskSets() {
        if (this.context.getTlsContext().getPskSets() != null) {
            return this.context.getTlsContext().getPskSets();
        }
        return this.config.getDefaultPskSets();
    }

    @Override
    public CipherSuite getEarlyDataCipherSuite() {
        if (this.context.getTlsContext().getEarlyDataCipherSuite() != null) {
            return this.context.getTlsContext().getEarlyDataCipherSuite();
        }
        return this.config.getEarlyDataCipherSuite();
    }

    @Override
    public byte[] getClientEarlyTrafficSecret() {
        if (this.context.getTlsContext().getClientEarlyTrafficSecret() != null) {
            return this.copy(this.context.getTlsContext().getClientEarlyTrafficSecret());
        }
        return this.config.getClientEarlyTrafficSecret();
    }

    @Override
    public byte[] getEarlySecret() {
        if (this.context.getTlsContext().getEarlySecret() != null) {
            return this.copy(this.context.getTlsContext().getEarlySecret());
        }
        return this.config.getEarlySecret();
    }

    @Override
    public byte[] getEarlyDataPsk() {
        if (this.context.getTlsContext().getEarlyDataPsk() != null) {
            return this.copy(this.context.getTlsContext().getEarlyDataPsk());
        }
        return this.config.getEarlyDataPsk();
    }

    @Override
    public ConnectionEndType getConnectionEndType() {
        return this.getConnection().getLocalConnectionEndType();
    }

    @Override
    public List<KeyShareStoreEntry> getClientKeyShares() {
        if (this.context.getTlsContext().getClientKeyShareStoreEntryList() != null) {
            return this.context.getTlsContext().getClientKeyShareStoreEntryList();
        }
        return this.config.getDefaultClientKeyStoreEntries();
    }

    @Override
    public KeyShareStoreEntry getServerKeyShare() {
        if (this.context.getTlsContext().getServerKeyShareStoreEntry() != null) {
            return this.context.getTlsContext().getServerKeyShareStoreEntry();
        }
        return this.config.getDefaultServerKeyShareEntry();
    }

    @Override
    public byte[] getHandshakeSecret() {
        if (this.context.getTlsContext().getHandshakeSecret() != null) {
            return this.copy(this.context.getTlsContext().getHandshakeSecret());
        }
        return this.config.getDefaultHandshakeSecret();
    }

    private byte[] copy(byte[] array) {
        return Arrays.copyOf((byte[])array, (int)array.length);
    }

    @Override
    public String getClientPWDUsername() {
        if (this.context.getTlsContext().getClientPWDUsername() != null) {
            return this.context.getTlsContext().getClientPWDUsername();
        }
        return this.config.getDefaultClientPWDUsername();
    }

    @Override
    public byte[] getServerPWDSalt() {
        if (this.context.getTlsContext().getServerPWDSalt() != null) {
            return this.context.getTlsContext().getServerPWDSalt();
        }
        return this.config.getDefaultServerPWDSalt();
    }

    @Override
    public String getPWDPassword() {
        return this.config.getDefaultPWDPassword();
    }

    @Override
    public byte[] getEsniClientNonce() {
        if (this.context.getTlsContext().getEsniClientNonce() != null) {
            return this.context.getTlsContext().getEsniClientNonce();
        }
        return this.config.getDefaultEsniClientNonce();
    }

    @Override
    public byte[] getEsniServerNonce() {
        if (this.context.getTlsContext().getEsniServerNonce() != null) {
            return this.context.getTlsContext().getEsniServerNonce();
        }
        return this.config.getDefaultEsniServerNonce();
    }

    @Override
    public byte[] getEsniRecordBytes() {
        if (this.context.getTlsContext().getEsniRecordBytes() != null) {
            return this.context.getTlsContext().getEsniRecordBytes();
        }
        return this.config.getDefaultEsniRecordBytes();
    }

    @Override
    public EsniDnsKeyRecordVersion getEsniRecordVersion() {
        if (this.context.getTlsContext().getEsniRecordVersion() != null) {
            return this.context.getTlsContext().getEsniRecordVersion();
        }
        return this.config.getDefaultEsniRecordVersion();
    }

    @Override
    public byte[] getEsniRecordChecksum() {
        if (this.context.getTlsContext().getEsniRecordChecksum() != null) {
            return this.context.getTlsContext().getEsniRecordChecksum();
        }
        return this.config.getDefaultEsniRecordChecksum();
    }

    @Override
    public List<KeyShareStoreEntry> getEsniServerKeyShareEntries() {
        if (this.context.getTlsContext().getEsniServerKeyShareEntries() != null && !this.context.getTlsContext().getEsniServerKeyShareEntries().isEmpty()) {
            return this.context.getTlsContext().getEsniServerKeyShareEntries();
        }
        return this.config.getDefaultEsniServerKeyShareEntries();
    }

    @Override
    public List<CipherSuite> getEsniServerCipherSuites() {
        if (this.context.getTlsContext().getEsniServerCipherSuites() != null) {
            return this.context.getTlsContext().getEsniServerCipherSuites();
        }
        return this.config.getDefaultEsniServerCipherSuites();
    }

    @Override
    public Integer getEsniPaddedLength() {
        if (this.context.getTlsContext().getEsniPaddedLength() != null) {
            return this.context.getTlsContext().getEsniPaddedLength();
        }
        return this.config.getDefaultEsniPaddedLength();
    }

    @Override
    public Long getEsniNotBefore() {
        if (this.context.getTlsContext().getEsniKeysNotBefore() != null) {
            return this.context.getTlsContext().getEsniKeysNotBefore();
        }
        return this.config.getDefaultEsniNotBefore();
    }

    @Override
    public Long getEsniNotAfter() {
        if (this.context.getTlsContext().getEsniNotAfter() != null) {
            return this.context.getTlsContext().getEsniNotAfter();
        }
        return this.config.getDefaultEsniNotAfter();
    }

    @Override
    public List<String> getProposedAlpnProtocols() {
        if (this.context.getTlsContext().getProposedAlpnProtocols() != null) {
            return this.context.getTlsContext().getProposedAlpnProtocols();
        }
        return this.config.getDefaultProposedAlpnProtocols();
    }

    @Override
    public Integer getMaxEarlyDataSize() {
        if (this.context.getTlsContext().getMaxEarlyDataSize() != null) {
            return this.context.getTlsContext().getMaxEarlyDataSize();
        }
        return this.config.getDefaultMaxEarlyDataSize();
    }

    @Override
    public byte[] getLastClientHello() {
        if (this.context.getTlsContext().getLastClientHello() != null) {
            return this.context.getTlsContext().getLastClientHello();
        }
        return this.config.getDefaultLastClientHello();
    }

    @Override
    public byte[] getExtensionCookie() {
        if (this.context.getTlsContext().getExtensionCookie() != null) {
            return this.context.getTlsContext().getExtensionCookie();
        }
        return this.config.getDefaultExtensionCookie();
    }

    @Override
    public BigInteger getServerEphemeralDhModulus() {
        if (this.context.getTlsContext().getServerEphemeralDhModulus() != null) {
            return this.context.getTlsContext().getServerEphemeralDhModulus();
        }
        return this.config.getDefaultServerEphemeralDhModulus();
    }

    @Override
    public BigInteger getServerEphemeralDhGenerator() {
        if (this.context.getTlsContext().getServerEphemeralDhGenerator() != null) {
            return this.context.getTlsContext().getServerEphemeralDhGenerator();
        }
        return this.config.getDefaultServerEphemeralDhGenerator();
    }

    @Override
    public BigInteger getServerEphemeralDhPrivateKey() {
        if (this.context.getTlsContext().getServerEphemeralDhPrivateKey() != null) {
            return this.context.getTlsContext().getServerEphemeralDhPrivateKey();
        }
        return this.config.getDefaultServerEphemeralDhPrivateKey();
    }

    @Override
    public BigInteger getClientEphemeralDhPrivateKey() {
        if (this.context.getTlsContext().getClientEphemeralDhPrivateKey() != null) {
            return this.context.getTlsContext().getClientEphemeralDhPrivateKey();
        }
        return this.config.getDefaultClientEphemeralDhPrivateKey();
    }

    @Override
    public BigInteger getServerEphemeralDhPublicKey() {
        if (this.context.getTlsContext().getServerEphemeralDhPublicKey() != null) {
            return this.context.getTlsContext().getServerEphemeralDhPublicKey();
        }
        return this.config.getDefaultServerEphemeralDhPublicKey();
    }

    @Override
    public BigInteger getClientEphemeralDhPublicKey() {
        if (this.context.getTlsContext().getClientEphemeralDhPublicKey() != null) {
            return this.context.getTlsContext().getClientEphemeralDhPublicKey();
        }
        return this.config.getDefaultClientEphemeralDhPublicKey();
    }

    @Override
    public BigInteger getServerEphemeralEcPrivateKey() {
        if (this.context.getTlsContext().getServerEphemeralEcPrivateKey() != null) {
            return this.context.getTlsContext().getServerEphemeralEcPrivateKey();
        }
        return this.config.getDefaultServerEphemeralEcPrivateKey();
    }

    @Override
    public BigInteger getClientEphemeralEcPrivateKey() {
        if (this.context.getTlsContext().getClientEphemeralEcPrivateKey() != null) {
            return this.context.getTlsContext().getClientEphemeralEcPrivateKey();
        }
        return this.config.getDefaultClientEphemeralEcPrivateKey();
    }

    @Override
    public Point getClientEphemeralEcPublicKey() {
        if (this.context.getTlsContext().getClientEphemeralEcPublicKey() != null) {
            return this.context.getTlsContext().getClientEphemeralEcPublicKey();
        }
        return this.config.getDefaultClientEphemeralEcPublicKey();
    }

    @Override
    public Point getServerEphemeralEcPublicKey() {
        if (this.context.getTlsContext().getServerEphemeralEcPublicKey() != null) {
            return this.context.getTlsContext().getServerEphemeralEcPublicKey();
        }
        return this.config.getDefaultServerEphemeralEcPublicKey();
    }

    @Override
    public BigInteger getServerEphemeralRsaExportModulus() {
        if (this.context.getTlsContext().getServerEphemeralRsaExportModulus() != null) {
            return this.context.getTlsContext().getServerEphemeralRsaExportModulus();
        }
        return this.config.getDefaultServerEphemeralRsaExportModulus();
    }

    @Override
    public BigInteger getServerEphemeralRsaExportPublicKey() {
        if (this.context.getTlsContext().getServerEphemeralRsaExportPublicKey() != null) {
            return this.context.getTlsContext().getServerEphemeralRsaExportPublicKey();
        }
        return this.config.getDefaultServerEphemeralRsaExportPublicKey();
    }

    @Override
    public BigInteger getServerEphemeralRsaExportPrivateKey() {
        if (this.context.getTlsContext().getServerEphemeralRsaExportPrivateKey() != null) {
            return this.context.getTlsContext().getServerEphemeralRsaExportPrivateKey();
        }
        return this.config.getDefaultServerEphemeralRsaExportPrivateKey();
    }

    @Override
    public BigInteger getRsaKeyExchangePublicExponent() {
        return this.getServerX509Chooser().getSubjectRsaPublicExponent();
    }

    @Override
    public BigInteger getRsaKeyExchangeModulus() {
        return this.getServerX509Chooser().getSubjectRsaModulus();
    }

    @Override
    public BigInteger getRsaKeyExchangePrivateKey() {
        return this.getServerX509Chooser().getSubjectRsaPrivateKey();
    }

    @Override
    public BigInteger getDhKeyExchangePeerPublicKey() {
        KeyExchangeAlgorithm algorithm = this.getSelectedCipherSuite().getKeyExchangeAlgorithm();
        if (algorithm != null && algorithm.isKeyExchangeStaticDh()) {
            return this.context.getTlsContext().getPeerX509Context().getChooser().getSubjectDhPublicKey();
        }
        if (this.getConnectionEndType() == ConnectionEndType.CLIENT) {
            return this.getServerEphemeralDhPublicKey();
        }
        return this.getClientEphemeralDhPublicKey();
    }

    @Override
    public BigInteger getDhKeyExchangeModulus() {
        KeyExchangeAlgorithm algorithm = this.getSelectedCipherSuite().getKeyExchangeAlgorithm();
        if (algorithm != null && algorithm.isKeyExchangeStaticDh()) {
            return this.context.getTlsContext().getPeerX509Context().getChooser().getSubjectDhModulus();
        }
        return this.getServerEphemeralDhModulus();
    }

    @Override
    public BigInteger getDhKeyExchangeGenerator() {
        KeyExchangeAlgorithm algorithm = this.getSelectedCipherSuite().getKeyExchangeAlgorithm();
        if (algorithm != null && algorithm.isKeyExchangeStaticDh()) {
            return this.context.getTlsContext().getPeerX509Context().getChooser().getSubjectDhGenerator();
        }
        return this.getServerEphemeralDhGenerator();
    }

    @Override
    public BigInteger getDhKeyExchangePrivateKey() {
        KeyExchangeAlgorithm algorithm = this.getSelectedCipherSuite().getKeyExchangeAlgorithm();
        if (algorithm != null && algorithm.isKeyExchangeStaticDh()) {
            return this.context.getTlsContext().getTalkingX509Context().getChooser().getSubjectDhPrivateKey();
        }
        if (this.getConnectionEndType() == ConnectionEndType.CLIENT) {
            return this.getClientEphemeralDhPrivateKey();
        }
        return this.getServerEphemeralDhPrivateKey();
    }

    @Override
    public Point getEcKeyExchangePeerPublicKey() {
        KeyExchangeAlgorithm algorithm = this.getSelectedCipherSuite().getKeyExchangeAlgorithm();
        if (algorithm != null && algorithm.isKeyExchangeStaticEcdh()) {
            return this.context.getTlsContext().getPeerX509Context().getChooser().getSubjectEcPublicKey();
        }
        if (this.getConnectionEndType() == ConnectionEndType.CLIENT) {
            return this.getServerEphemeralEcPublicKey();
        }
        return this.getClientEphemeralEcPublicKey();
    }

    @Override
    public BigInteger getEcKeyExchangePrivateKey() {
        KeyExchangeAlgorithm algorithm = this.getSelectedCipherSuite().getKeyExchangeAlgorithm();
        if (algorithm != null && algorithm.isKeyExchangeStaticEcdh()) {
            return this.context.getTlsContext().getTalkingX509Context().getChooser().getSubjectEcPrivateKey();
        }
        if (this.getConnectionEndType() == ConnectionEndType.CLIENT) {
            return this.getClientEphemeralEcPrivateKey();
        }
        return this.getServerEphemeralEcPrivateKey();
    }

    @Override
    public BigInteger getKeySharePrivateKey(NamedGroup keyStoreGroup) {
        if (keyStoreGroup.isDhGroup()) {
            if (this.getConnectionEndType() == ConnectionEndType.CLIENT) {
                return this.getClientEphemeralDhPrivateKey();
            }
            return this.getServerEphemeralDhPrivateKey();
        }
        if (this.getConnectionEndType() == ConnectionEndType.CLIENT) {
            return this.getClientEphemeralEcPrivateKey();
        }
        return this.getServerEphemeralEcPrivateKey();
    }

    @Override
    public Integer getPeerReceiveLimit() {
        if (this.context.getTlsContext().getPeerReceiveLimit() != null) {
            return this.context.getTlsContext().getPeerReceiveLimit();
        }
        return this.config.getDefaultAssumedMaxReceiveLimit();
    }

    @Override
    public EchConfig getEchConfig() {
        if (this.context != null && this.context.getTlsContext().getEchConfig() != null) {
            return this.context.getTlsContext().getEchConfig();
        }
        return this.config.getDefaultEchConfig();
    }

    @Override
    public KeyShareEntry getEchClientKeyShareEntry() {
        if (this.context != null && this.context.getTlsContext().getEchClientKeyShareEntry() != null) {
            return this.context.getTlsContext().getEchClientKeyShareEntry();
        }
        KeyShareEntry keyShareEntry = new KeyShareEntry();
        keyShareEntry.setPrivateKey(this.config.getDefaultEchClientPrivateKey());
        KeyShareEntryPreparator keyShareEntryPreparator = new KeyShareEntryPreparator((Chooser)this, keyShareEntry);
        keyShareEntry.setGroupConfig(this.getEchConfig().getKem().getNamedGroup());
        keyShareEntryPreparator.prepare();
        if (this.context != null) {
            this.context.getTlsContext().setEchClientKeyShareEntry(keyShareEntry);
        }
        return keyShareEntry;
    }

    @Override
    public KeyShareEntry getEchServerKeyShareEntry() {
        if (this.context != null && this.context.getTlsContext() != null && this.context.getTlsContext().getEchClientKeyShareEntry() != null) {
            return this.context.getTlsContext().getEchServerKeyShareEntry();
        }
        KeyShareEntry keyShareEntry = new KeyShareEntry();
        keyShareEntry.setPrivateKey(this.config.getDefaultEchServerPrivateKey());
        KeyShareEntryPreparator keyShareEntryPreparator = new KeyShareEntryPreparator((Chooser)this, keyShareEntry);
        keyShareEntry.setGroupConfig(this.getEchConfig().getKem().getNamedGroup());
        keyShareEntryPreparator.prepare();
        if (this.context != null) {
            this.context.getTlsContext().setEchServerKeyShareEntry(keyShareEntry);
        }
        return keyShareEntry;
    }

    @Override
    public Integer getNumberOfRequestedConnectionIds() {
        if (this.context.getTlsContext().getNumberOfRequestedConnectionIds() != null) {
            return this.context.getTlsContext().getNumberOfRequestedConnectionIds();
        }
        return this.config.getDefaultNumberOfRequestedConnectionIds();
    }

    @Override
    public SrtpProtectionProfile getSelectedSrtpProtectionProfile() {
        if (this.context.getTlsContext().getSelectedSrtpProtectionProfile() != null) {
            return this.context.getTlsContext().getSelectedSrtpProtectionProfile();
        }
        return this.config.getDefaultSelectedSrtpProtectionProfile();
    }
}

