/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action.executor;

import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.Record;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MessageActionResult {
    private final List<Record> recordList;
    private final List<ProtocolMessage> messageList;
    private List<DtlsHandshakeMessageFragment> messageFragmentList;

    public MessageActionResult(List<Record> recordList, List<ProtocolMessage> messageList, List<DtlsHandshakeMessageFragment> messageFragmentList) {
        this.recordList = recordList;
        this.messageList = messageList;
        this.messageFragmentList = messageFragmentList;
    }

    public MessageActionResult() {
        this(new LinkedList<Record>(), new LinkedList<ProtocolMessage>(), new LinkedList<DtlsHandshakeMessageFragment>());
    }

    public List<Record> getRecordList() {
        return this.recordList;
    }

    public List<ProtocolMessage> getMessageList() {
        return this.messageList;
    }

    public List<DtlsHandshakeMessageFragment> getMessageFragmentList() {
        return this.messageFragmentList;
    }

    public MessageActionResult merge(MessageActionResult ... other) {
        LinkedList<MessageActionResult> results = new LinkedList<MessageActionResult>(Arrays.asList(other));
        results.add(0, this);
        LinkedList<Record> recordList = new LinkedList<Record>();
        LinkedList<DtlsHandshakeMessageFragment> messageFragmentList = null;
        LinkedList<ProtocolMessage> messageList = new LinkedList<ProtocolMessage>();
        for (MessageActionResult result : other) {
            recordList.addAll(result.getRecordList());
            if (result.getMessageFragmentList() != null) {
                if (messageFragmentList == null) {
                    messageFragmentList = new LinkedList<DtlsHandshakeMessageFragment>();
                }
                messageFragmentList.addAll(result.getMessageFragmentList());
            }
            messageList.addAll(result.getMessageList());
        }
        return new MessageActionResult(recordList, messageList, messageFragmentList);
    }
}

