/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.TightReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="TightReceive")
public class TightReceiveAction
extends CommonReceiveAction {
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<ProtocolMessage> expectedMessages;

    public TightReceiveAction() {
    }

    public TightReceiveAction(List<ProtocolMessage> expectedMessages) {
        this.expectedMessages = expectedMessages;
    }

    public TightReceiveAction(ProtocolMessage ... expectedMessages) {
        this.expectedMessages = Arrays.asList(expectedMessages);
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        LinkedList configurationList = new LinkedList();
        configurationList.add(new TightReceiveLayerConfiguration<ProtocolMessage>((LayerType)ImplementedLayers.SSL2, this.expectedMessages));
        configurationList.add(new TightReceiveLayerConfiguration<ProtocolMessage>((LayerType)ImplementedLayers.MESSAGE, this.expectedMessages));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), false, this.getActionOptions(), configurationList);
    }
}

