/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="Renegotiation")
public class RenegotiationAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean resetLastVerifyData = false;

    public RenegotiationAction() {
    }

    public RenegotiationAction(boolean resetLastVerifyData) {
        this.resetLastVerifyData = resetLastVerifyData;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getContext(this.getConnectionAlias()).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        LOGGER.info("Resetting MessageDigest");
        tlsContext.getDigest().reset();
        LOGGER.info("Resetting DTLS numbers and cookie");
        tlsContext.setDtlsCookie(null);
        if (tlsContext.getDtlsFragmentLayer() != null) {
            tlsContext.getDtlsFragmentLayer().setReadHandshakeMessageSequence(0);
            tlsContext.getDtlsFragmentLayer().setWriteHandshakeMessageSequence(0);
            tlsContext.getDtlsFragmentLayer().resetFragmentManager(state.getConfig());
        }
        tlsContext.getDtlsReceivedChangeCipherSpecEpochs().clear();
        tlsContext.getDtlsReceivedHandshakeMessageSequences().clear();
        if (this.resetLastVerifyData) {
            LOGGER.info("Resetting SecureRenegotiation");
            tlsContext.setLastClientVerifyData(null);
            tlsContext.setLastServerVerifyData(null);
        }
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

