/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.http.HttpMessage;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.printer.LogPrinter;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.StaticReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="Receive")
public class ReceiveAction
extends CommonReceiveAction
implements StaticReceivingAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<ProtocolMessage> expectedMessages;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<SSL2Message> expectedSSL2Messages;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<Record> expectedRecords;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<DtlsHandshakeMessageFragment> expectedDtlsFragments;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<HttpMessage> expectedHttpMessages;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicFrame> expectedQuicFrames;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicPacket> expectedQuicPackets;

    public ReceiveAction() {
    }

    public ReceiveAction(Set<ActionOption> actionOptions, List<ProtocolMessage> expectedMessages, List<QuicFrame> expectedQuicFrames, List<QuicPacket> quicPackets) {
        this.setActionOptions(actionOptions);
        this.expectedMessages = expectedMessages;
        this.expectedQuicFrames = expectedQuicFrames;
        this.expectedQuicPackets = quicPackets;
    }

    public ReceiveAction(List<ProtocolMessage> expectedMessages) {
        this.expectedMessages = expectedMessages;
    }

    public ReceiveAction(ProtocolMessage ... expectedMessages) {
        this.expectedMessages = new ArrayList<ProtocolMessage>(Arrays.asList(expectedMessages));
    }

    public ReceiveAction(QuicFrame ... expectedQuicFrames) {
        this.expectedQuicFrames = new ArrayList<QuicFrame>(Arrays.asList(expectedQuicFrames));
    }

    public ReceiveAction(QuicPacket ... expectedQuicPackets) {
        this.expectedQuicPackets = new ArrayList<QuicPacket>(Arrays.asList(expectedQuicPackets));
    }

    public ReceiveAction(ActionOption actionOption, QuicFrame ... expectedQuicFrames) {
        this(expectedQuicFrames);
        if (actionOption != null) {
            this.addActionOption(actionOption);
        }
    }

    public ReceiveAction(ActionOption actionOption, QuicPacket ... expectedQuicPackets) {
        this(expectedQuicPackets);
        if (actionOption != null) {
            this.addActionOption(actionOption);
        }
    }

    public ReceiveAction(ActionOption actionOption, List<QuicFrame> expectedQuicFrames, List<QuicPacket> expectedQuicPackets) {
        this.expectedQuicFrames = expectedQuicFrames;
        this.expectedQuicPackets = expectedQuicPackets;
        if (actionOption != null) {
            this.addActionOption(actionOption);
        }
    }

    public ReceiveAction(Set<ActionOption> actionOptions, List<QuicFrame> expectedQuicFrames, List<QuicPacket> expectedQuicPackets) {
        this.expectedQuicFrames = expectedQuicFrames;
        this.expectedQuicPackets = expectedQuicPackets;
        this.setActionOptions(actionOptions);
    }

    public ReceiveAction(List<ProtocolMessage> expectedMessages, List<HttpMessage> expectedHttpMessages) {
        this(expectedMessages);
        this.expectedHttpMessages = expectedHttpMessages;
    }

    public ReceiveAction(HttpMessage ... expectedHttpMessages) {
        this.expectedHttpMessages = new ArrayList<HttpMessage>(Arrays.asList(expectedHttpMessages));
    }

    public ReceiveAction(Set<ActionOption> myActionOptions, List<ProtocolMessage> messages) {
        this(messages);
        this.setActionOptions(myActionOptions);
    }

    public ReceiveAction(Set<ActionOption> actionOptions, ProtocolMessage ... messages) {
        this(actionOptions, new ArrayList<ProtocolMessage>(Arrays.asList(messages)));
    }

    public ReceiveAction(Set<ActionOption> actionOptions, SSL2Message ... messages) {
        this.setActionOptions(actionOptions);
        this.expectedSSL2Messages = new ArrayList<SSL2Message>(Arrays.asList(messages));
    }

    public ReceiveAction(SSL2Message ... messages) {
        this.expectedSSL2Messages = new ArrayList<SSL2Message>(Arrays.asList(messages));
    }

    public ReceiveAction(ActionOption actionOption, List<ProtocolMessage> messages) {
        this(messages);
        this.setActionOptions(Set.of(actionOption));
    }

    public ReceiveAction(ActionOption actionOption, ProtocolMessage ... messages) {
        this(actionOption, new ArrayList<ProtocolMessage>(Arrays.asList(messages)));
    }

    public ReceiveAction(String connectionAlias) {
        super(connectionAlias);
    }

    public ReceiveAction(String connectionAliasAlias, List<ProtocolMessage> messages) {
        super(connectionAliasAlias);
        this.expectedMessages = messages;
    }

    public ReceiveAction(String connectionAliasAlias, ProtocolMessage ... messages) {
        this(connectionAliasAlias, new ArrayList<ProtocolMessage>(Arrays.asList(messages)));
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + ": " + (this.isExecuted() ? "\n" : "(not executed)\n") + "\tExpected: " + LogPrinter.toHumanReadableMultiLineContainerListArray(this.getExpectedDataContainerLists(), LOGGER.getLevel());
        if (this.isExecuted()) {
            string = string + "\n\tActual: " + LogPrinter.toHumanReadableMultiLine(this.getLayerStackProcessingResult(), LOGGER.getLevel());
        }
        return string;
    }

    @Override
    public String toCompactString() {
        return LogPrinter.toHumanReadableMultiLineContainerListArray(this.getExpectedDataContainerLists(), LOGGER.getLevel());
    }

    public List<ProtocolMessage> getExpectedMessages() {
        return this.expectedMessages;
    }

    public void setExpectedMessages(List<ProtocolMessage> expectedMessages) {
        this.expectedMessages = expectedMessages;
    }

    public void setExpectedMessages(ProtocolMessage ... expectedMessages) {
        this.expectedMessages = new ArrayList<ProtocolMessage>(Arrays.asList(expectedMessages));
    }

    public List<SSL2Message> getExpectedSSL2Messages() {
        return this.expectedSSL2Messages;
    }

    public void setExpectedSSL2Messages(List<SSL2Message> expectedSSL2Messages) {
        this.expectedSSL2Messages = expectedSSL2Messages;
    }

    public void setExpectedSSL2Messages(SSL2Message ... expectedSSL2Messages) {
        this.expectedSSL2Messages = new ArrayList<SSL2Message>(Arrays.asList(expectedSSL2Messages));
    }

    public List<HttpMessage> getExpectedHttpMessages() {
        return this.expectedHttpMessages;
    }

    public void setExpectedHttpMessages(List<HttpMessage> expectedHttpMessages) {
        this.expectedHttpMessages = expectedHttpMessages;
    }

    public List<QuicFrame> getExpectedQuicFrames() {
        return this.expectedQuicFrames;
    }

    public void setExpectedQuicFrames(List<QuicFrame> expectedQuicFrames) {
        this.expectedQuicFrames = expectedQuicFrames;
    }

    public List<QuicPacket> getExpectedQuicPackets() {
        return this.expectedQuicPackets;
    }

    public void setExpectedQuicPackets(List<QuicPacket> expectedQuicPackets) {
        this.expectedQuicPackets = expectedQuicPackets;
    }

    public List<Record> getExpectedRecords() {
        return this.expectedRecords;
    }

    public void setExpectedRecords(List<Record> expectedRecords) {
        this.expectedRecords = expectedRecords;
    }

    public List<DtlsHandshakeMessageFragment> getExpectedDtlsFragments() {
        return this.expectedDtlsFragments;
    }

    public void setExpectedDtlsFragments(List<DtlsHandshakeMessageFragment> expectedDtlsFragments) {
        this.expectedDtlsFragments = expectedDtlsFragments;
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        LinkedList configurationList = new LinkedList();
        if (this.getExpectedRecords() != null) {
            configurationList.add(new SpecificReceiveLayerConfiguration<Record>((LayerType)ImplementedLayers.RECORD, this.getExpectedRecords()));
        }
        if (this.getExpectedMessages() != null) {
            configurationList.add(new SpecificReceiveLayerConfiguration<ProtocolMessage>((LayerType)ImplementedLayers.MESSAGE, this.getExpectedMessages()));
        }
        if (this.getExpectedSSL2Messages() != null) {
            configurationList.add(new SpecificReceiveLayerConfiguration<SSL2Message>((LayerType)ImplementedLayers.SSL2, this.getExpectedSSL2Messages()));
        }
        if (this.getExpectedDtlsFragments() != null) {
            configurationList.add(new SpecificReceiveLayerConfiguration<DtlsHandshakeMessageFragment>((LayerType)ImplementedLayers.DTLS_FRAGMENT, this.getExpectedDtlsFragments()));
        }
        if (this.getExpectedHttpMessages() != null) {
            configurationList.add(new SpecificReceiveLayerConfiguration<HttpMessage>((LayerType)ImplementedLayers.HTTP, this.getExpectedHttpMessages()));
        }
        if (this.getExpectedQuicFrames() != null) {
            configurationList.add(new SpecificReceiveLayerConfiguration<QuicFrame>((LayerType)ImplementedLayers.QUICFRAME, this.getExpectedQuicFrames()));
        }
        if (this.getExpectedQuicPackets() != null) {
            configurationList.add(new SpecificReceiveLayerConfiguration<QuicPacket>((LayerType)ImplementedLayers.QUICPACKET, this.getExpectedQuicPackets()));
        }
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), false, this.getActionOptions(), configurationList);
    }

    @Override
    public List<List<DataContainer>> getExpectedDataContainerLists() {
        LinkedList<List<DataContainer>> dataContainerLists = new LinkedList<List<DataContainer>>();
        if (this.expectedHttpMessages != null) {
            dataContainerLists.add(this.expectedHttpMessages);
        }
        if (this.expectedMessages != null) {
            dataContainerLists.add(this.expectedMessages);
        }
        if (this.expectedSSL2Messages != null) {
            dataContainerLists.add(this.expectedSSL2Messages);
        }
        if (this.expectedDtlsFragments != null) {
            dataContainerLists.add(this.expectedDtlsFragments);
        }
        if (this.expectedRecords != null) {
            dataContainerLists.add(this.expectedRecords);
        }
        if (this.expectedQuicFrames != null) {
            dataContainerLists.add(this.expectedQuicFrames);
        }
        if (this.expectedQuicPackets != null) {
            dataContainerLists.add(this.expectedQuicPackets);
        }
        return dataContainerLists;
    }
}

