/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.quic.frame.PathChallengeFrame;
import de.rub.nds.tlsattacker.core.quic.frame.PathResponseFrame;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveQuicTillAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@XmlRootElement
public class QuicPathChallengeAction
extends ConnectionBoundAction {
    @XmlTransient
    protected boolean executedAsPlanned = false;
    @XmlTransient
    protected List<MessageAction> executedActions = new ArrayList<MessageAction>();
    @XmlTransient
    protected int pathChallengeCounter = 0;
    @XmlElement
    protected Boolean requireAtLeastOnePathChallenge = false;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicFrame> sendQuicFrames = new ArrayList<QuicFrame>();
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicPacket> sendQuicPackets = new ArrayList<QuicPacket>();
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicFrame> receivedQuicFrames = new ArrayList<QuicFrame>();
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicPacket> receivedQuicPackets = new ArrayList<QuicPacket>();

    public QuicPathChallengeAction(String connectionAlias) {
        super(connectionAlias);
    }

    public QuicPathChallengeAction(String connectionAlias, boolean requireAtLeastOnePathChallenge) {
        super(connectionAlias);
        this.requireAtLeastOnePathChallenge = requireAtLeastOnePathChallenge;
    }

    public QuicPathChallengeAction() {
    }

    public QuicPathChallengeAction(boolean requireAtLeastOnePathChallenge) {
        this.requireAtLeastOnePathChallenge = requireAtLeastOnePathChallenge;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        MessageAction action;
        do {
            ReceiveQuicTillAction receiveQuicTillAction = new ReceiveQuicTillAction(new PathChallengeFrame());
            receiveQuicTillAction.setConnectionAlias(this.getConnectionAlias());
            action = this.executeAction(state, receiveQuicTillAction);
            if (action.executedAsPlanned()) {
                action = this.executeAction(state, new SendAction(new PathResponseFrame()));
                if (!action.executedAsPlanned()) {
                    this.executedAsPlanned = false;
                    return;
                }
                ++this.pathChallengeCounter;
                continue;
            }
            if (this.pathChallengeCounter == 0 && this.requireAtLeastOnePathChallenge.booleanValue()) {
                this.executedAsPlanned = false;
                return;
            }
            this.executedAsPlanned = true;
            return;
        } while (action.executedAsPlanned());
    }

    private MessageAction executeAction(State state, MessageAction action) throws ActionExecutionException {
        action.execute(state);
        if (action instanceof SendAction) {
            this.sendQuicFrames.addAll(((SendingAction)((Object)action)).getSentQuicFrames());
            this.sendQuicPackets.addAll(((SendingAction)((Object)action)).getSentQuicPackets());
        } else {
            this.receivedQuicFrames.addAll(((ReceivingAction)((Object)action)).getReceivedQuicFrames());
            this.receivedQuicPackets.addAll(((ReceivingAction)((Object)action)).getReceivedQuicPackets());
        }
        this.executedActions.add(action);
        return action;
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + ": " + (this.isExecuted() ? "\n" : "(not executed)");
        if (this.isExecuted()) {
            string = string + "\n\tExecuted Actions:\t" + this.executedActions.stream().map(Object::toString).collect(Collectors.joining("\n\t"));
        }
        return string;
    }

    @Override
    public String toCompactString() {
        return super.toCompactString() + " (performed " + this.pathChallengeCounter + " path challenge(s))";
    }

    @Override
    public void reset() {
        this.executedAsPlanned = false;
        this.executedActions = null;
        this.pathChallengeCounter = 0;
        this.sendQuicFrames = null;
        this.sendQuicPackets = null;
        this.receivedQuicFrames = null;
        this.receivedQuicPackets = null;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.executedAsPlanned;
    }

    public List<QuicFrame> getSendQuicFrames() {
        return this.sendQuicFrames;
    }

    public List<QuicPacket> getSendQuicPackets() {
        return this.sendQuicPackets;
    }

    public List<QuicFrame> getReceivedQuicFrames() {
        return this.receivedQuicFrames;
    }

    public List<QuicPacket> getReceivedQuicPackets() {
        return this.receivedQuicPackets;
    }
}

