/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.GenericReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Arrays;
import java.util.List;

@XmlRootElement(name="MultiReceive")
public class MultiReceiveAction
extends GenericReceiveAction {
    private List<ReceiveAction> expectedActionCandidates;
    @XmlTransient
    private ReceiveAction selectedAction;

    public MultiReceiveAction() {
    }

    public MultiReceiveAction(ReceiveAction ... receiveActions) {
        this.expectedActionCandidates = Arrays.asList(receiveActions);
    }

    public MultiReceiveAction(String connectionAlias, ReceiveAction ... receiveActions) {
        super(connectionAlias);
        this.expectedActionCandidates = Arrays.asList(receiveActions);
    }

    public MultiReceiveAction(String connectionAlias, List<ReceiveAction> expectedActionCandidates) {
        super(connectionAlias);
        this.expectedActionCandidates = expectedActionCandidates;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.selectedAction.executedAsPlanned();
    }

    public ReceiveAction getSelectedAction() {
        return this.selectedAction;
    }

    @Override
    public void execute(State state) {
        super.execute(state);
        this.selectedAction = new ReceiveAction();
        for (ReceiveAction receiveAction : this.expectedActionCandidates) {
            if (!this.compareExpectedActionsWithReceivedActions2(receiveAction)) continue;
            this.selectedAction = receiveAction;
            break;
        }
        this.selectedAction.setExecuted(super.isExecuted());
    }

    public List<ReceiveAction> getExpectedActionCandidates() {
        return this.expectedActionCandidates;
    }

    private boolean compareExpectedActionsWithReceivedActions2(ReceiveAction actionCandidate) {
        actionCandidate.setLayerStackProcessingResult(super.getLayerStackProcessingResult());
        return actionCandidate.executedAsPlanned();
    }
}

