/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerStack;
import de.rub.nds.tlsattacker.core.layer.LayerStackProcessingResult;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.util.List;
import java.util.Set;

@XmlRootElement(name="MessageAction")
public abstract class MessageAction
extends ConnectionBoundAction {
    @XmlElement(name="result")
    private LayerStackProcessingResult layerStackProcessingResult;

    public MessageAction() {
    }

    public MessageAction(String connectionAlias) {
        super(connectionAlias);
    }

    public MessageAction(Set<ActionOption> actionOptions, String connectionAlias) {
        super(actionOptions, connectionAlias);
    }

    public MessageAction(Set<ActionOption> actionOptions) {
        super(actionOptions);
    }

    public boolean isSendingAction() {
        return this instanceof SendingAction;
    }

    public boolean isReceivingAction() {
        return this instanceof ReceivingAction;
    }

    protected LayerStackProcessingResult getReceiveResult(LayerStack layerStack, List<LayerConfiguration<?>> layerConfigurationList) {
        this.layerStackProcessingResult = layerStack.receiveData(layerConfigurationList);
        return this.layerStackProcessingResult;
    }

    protected LayerStackProcessingResult getSendResult(LayerStack layerStack, List<LayerConfiguration<?>> layerConfigurationList) throws IOException {
        this.layerStackProcessingResult = layerStack.sendData(layerConfigurationList);
        return this.layerStackProcessingResult;
    }

    public LayerStackProcessingResult getLayerStackProcessingResult() {
        return this.layerStackProcessingResult;
    }

    public abstract MessageActionDirection getMessageDirection();

    @Override
    public void reset() {
        this.layerStackProcessingResult = null;
        this.setExecuted(null);
    }

    void setLayerStackProcessingResult(LayerStackProcessingResult layerStackProcessingResult) {
        this.layerStackProcessingResult = layerStackProcessingResult;
    }

    public static enum MessageActionDirection {
        SENDING,
        RECEIVING;

    }
}

