/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.SvcbType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EchConfig;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EchConfigParser;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbill.DNS.HTTPSRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

@XmlRootElement
public class EchConfigDnsRequestAction
extends TlsAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private TlsContext tlsContext;
    private Config tlsConfig;

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        Message answer;
        Name domainName;
        this.tlsContext = state.getTlsContext();
        this.tlsConfig = state.getConfig();
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        String hostname = this.tlsConfig.getDefaultClientConnection().getHostname();
        try {
            domainName = Name.fromString((String)(hostname + "."));
        }
        catch (TextParseException e) {
            LOGGER.error("Cannot send DNS query for ip addresses. Please provide the domain name in the server_name parameter");
            this.setExecuted(true);
            return;
        }
        try {
            answer = this.getHttpRecordAnswer(domainName);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Could not reach DNS server");
            this.setExecuted(true);
            return;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to send DNS query");
            this.setExecuted(true);
            return;
        }
        LinkedList<EchConfig> echConfigs = new LinkedList<EchConfig>();
        echConfigs.addAll(this.getEchConfigsForAnswer(domainName, answer));
        if (!echConfigs.isEmpty()) {
            LOGGER.info("ECH config found for {}", (Object)domainName);
            this.tlsContext.setEchConfig((EchConfig)echConfigs.get(0));
            this.setExecuted(true);
            return;
        }
        LOGGER.warn("No ECH Configs available for {}. Trying authority server.", (Object)hostname);
        domainName = this.getAuthorityForAnswer(answer);
        if (domainName == null) {
            LOGGER.warn("No authority server given for {}", (Object)hostname);
            this.setExecuted(true);
            return;
        }
        try {
            answer = this.getHttpRecordAnswer(domainName);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Could not reach DNS server");
            this.setExecuted(true);
            return;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to send DNS query");
            this.setExecuted(true);
            return;
        }
        echConfigs.addAll(this.getEchConfigsForAnswer(domainName, answer));
        if (!echConfigs.isEmpty()) {
            LOGGER.info("ECH config found for {}", (Object)domainName);
            this.tlsContext.setEchConfig((EchConfig)echConfigs.get(0));
        } else {
            LOGGER.warn("No ECH Configs available for {}", (Object)hostname);
        }
        this.setExecuted(true);
    }

    private Name getAuthorityForAnswer(Message answer) {
        Name referredHost = null;
        List records = answer.getSection(2);
        for (Record receivedRecord : records) {
            if (receivedRecord.getType() != 6) continue;
            SOARecord soaRecord = (SOARecord)receivedRecord;
            referredHost = soaRecord.getName();
        }
        return referredHost;
    }

    private List<EchConfig> getEchConfigsForAnswer(Name domainName, Message answer) {
        byte[] echConfigBytes;
        LinkedList<EchConfig> echConfigs = new LinkedList<EchConfig>();
        LinkedList<String> echConfigStrings = new LinkedList<String>();
        List records = answer.getSection(1);
        for (Record receivedRecord : records) {
            if (receivedRecord.getType() != 65) continue;
            HTTPSRecord httpsRecord = (HTTPSRecord)receivedRecord;
            for (Integer i : httpsRecord.getSvcParamKeys()) {
                if (!Objects.equals(i, SvcbType.ECH.getCode())) continue;
                echConfigStrings.add(httpsRecord.getSvcParamValue(i.intValue()).toString());
            }
        }
        if (echConfigStrings.isEmpty()) {
            return echConfigs;
        }
        String echConfigsStr = (String)echConfigStrings.get(0);
        try {
            echConfigBytes = Base64.getMimeDecoder().decode(echConfigsStr);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to base64 decode Resource Record for" + String.valueOf(domainName) + ". ECH Config: " + echConfigsStr);
            return echConfigs;
        }
        LOGGER.debug("echConfigStr: {}", (Object)echConfigsStr);
        LOGGER.debug("echConfigBytes: {}", (Object)echConfigBytes);
        EchConfigParser echConfigParser = new EchConfigParser(new ByteArrayInputStream(echConfigBytes), this.tlsContext);
        echConfigParser.parse((List<EchConfig>)echConfigs);
        return echConfigs;
    }

    private Message getHttpRecordAnswer(Name domainName) throws IOException {
        SimpleResolver resolver = new SimpleResolver(this.tlsConfig.getDefaultDnsServer());
        Record record = Record.newRecord((Name)domainName, (int)65, (int)1);
        Message message = Message.newQuery((Record)record);
        LOGGER.debug("Sending DNS request to get ECH Config for: {}", (Object)domainName);
        Message answer = resolver.send(message);
        return answer;
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

