/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.workflow.action.CopyContextFieldAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="DeepCopyBufferedMessages")
public class DeepCopyBufferedMessagesAction
extends CopyContextFieldAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public DeepCopyBufferedMessagesAction() {
    }

    public DeepCopyBufferedMessagesAction(String srcConnectionAlias, String dstConnectionAlias) {
        super(srcConnectionAlias, dstConnectionAlias);
    }

    @Override
    protected void copyField(TlsContext src, TlsContext dst) {
        this.deepCopyMessages(src, dst);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }

    private void deepCopyMessages(TlsContext src, TlsContext dst) {
        LinkedList<ProtocolMessage> messageBuffer = new LinkedList<ProtocolMessage>();
        try {
            for (ProtocolMessage message : src.getMessageBuffer()) {
                SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
                ObjectOutputStream outStream = new ObjectOutputStream((OutputStream)stream);
                outStream.writeObject(message);
                ObjectInputStream inStream = new ObjectInputStream(new ByteArrayInputStream(stream.toByteArray()));
                ProtocolMessage messageCopy = (ProtocolMessage)inStream.readObject();
                messageBuffer.add(messageCopy);
                this.setExecuted(true);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            this.setExecuted(this.getActionOptions().contains((Object)ActionOption.MAY_FAIL));
            LOGGER.error("Error while creating deep copy of messageBuffer");
            throw new ActionExecutionException(ex.toString());
        }
        dst.setMessageBuffer(messageBuffer);
    }
}

