/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerStackProcessingResult;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.printer.LogPrinter;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.tcp.TcpStreamContainer;
import de.rub.nds.tlsattacker.core.udp.UdpDataPacket;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommonSendAction
extends MessageAction
implements SendingAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public CommonSendAction() {
    }

    public CommonSendAction(String connectionAlias) {
        super(connectionAlias);
    }

    public CommonSendAction(Set<ActionOption> actionOptions, String connectionAlias) {
        super(actionOptions, connectionAlias);
    }

    @Override
    public final Set<String> getAllSendingAliases() {
        return new HashSet<String>(Collections.singleton(this.connectionAlias));
    }

    @Override
    public final MessageAction.MessageActionDirection getMessageDirection() {
        return MessageAction.MessageActionDirection.SENDING;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getContext(this.connectionAlias).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        List<LayerConfiguration<?>> layerConfigurations = this.createLayerConfiguration(state);
        if (layerConfigurations == null) {
            LOGGER.info("Not sending messages");
            this.setLayerStackProcessingResult(new LayerStackProcessingResult(new LinkedList()));
            this.setExecuted(true);
        } else {
            if (this.hasDefaultAlias()) {
                LOGGER.info("Sending messages: {}", (Object)LogPrinter.toHumanReadableOneLine(layerConfigurations, LOGGER.getLevel()));
            } else {
                LOGGER.info("Sending messages ({}): {}", (Object)this.connectionAlias, (Object)LogPrinter.toHumanReadableOneLine(layerConfigurations, LOGGER.getLevel()));
            }
            try {
                this.getSendResult(tlsContext.getLayerStack(), layerConfigurations);
                this.setExecuted(true);
            }
            catch (IOException e) {
                if (this.getActionOptions() == null || !this.getActionOptions().contains((Object)ActionOption.MAY_FAIL)) {
                    tlsContext.setReceivedTransportHandlerException(true);
                    LOGGER.debug("Encountered exception", (Throwable)e);
                }
                this.setExecuted(true);
            }
        }
    }

    protected abstract List<LayerConfiguration<?>> createLayerConfiguration(State var1);

    @Override
    public final List<DtlsHandshakeMessageFragment> getSentFragments() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.DTLS_FRAGMENT, this.getLayerStackProcessingResult()).stream().map(container -> (DtlsHandshakeMessageFragment)container).collect(Collectors.toList());
    }

    @Override
    public final List<ProtocolMessage> getSentMessages() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.MESSAGE, this.getLayerStackProcessingResult()).stream().map(container -> (ProtocolMessage)container).collect(Collectors.toList());
    }

    @Override
    public final List<SSL2Message> getSentSSL2Messages() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.SSL2, this.getLayerStackProcessingResult()).stream().map(container -> (SSL2Message)container).collect(Collectors.toList());
    }

    @Override
    public final List<QuicFrame> getSentQuicFrames() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.QUICFRAME, this.getLayerStackProcessingResult()).stream().map(container -> (QuicFrame)container).collect(Collectors.toList());
    }

    @Override
    public final List<QuicPacket> getSentQuicPackets() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.QUICPACKET, this.getLayerStackProcessingResult()).stream().map(container -> (QuicPacket)container).collect(Collectors.toList());
    }

    @Override
    public final List<Record> getSentRecords() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.RECORD, this.getLayerStackProcessingResult()).stream().map(container -> (Record)container).collect(Collectors.toList());
    }

    @Override
    public final List<TcpStreamContainer> getSentTcpStreamContainers() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.TCP, this.getLayerStackProcessingResult()).stream().map(container -> (TcpStreamContainer)container).collect(Collectors.toList());
    }

    @Override
    public final List<UdpDataPacket> getSentUdpDataPackets() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.UDP, this.getLayerStackProcessingResult()).stream().map(container -> (UdpDataPacket)container).collect(Collectors.toList());
    }

    @Override
    public boolean executedAsPlanned() {
        if (this.getLayerStackProcessingResult() != null) {
            return this.getLayerStackProcessingResult().executedAsPlanned();
        }
        return false;
    }
}

