/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ChangeServerRsaParameters")
public class ChangeServerRsaParametersAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private BigInteger modulus = null;
    private BigInteger publicExponent = null;
    private BigInteger privateExponent = null;

    public ChangeServerRsaParametersAction(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent) {
        this.modulus = modulus;
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
    }

    public ChangeServerRsaParametersAction() {
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        state.getTlsContext().getServerX509Context().setSubjectRsaModulus(this.modulus);
        state.getTlsContext().getServerX509Context().setSubjectRsaPublicExponent(this.publicExponent);
        state.getTlsContext().getServerX509Context().setSubjectRsaPrivateExponent(this.privateExponent);
        this.setExecuted(true);
        LOGGER.info("Changed server RSA parameters");
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

