/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeSequenceNumberAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ChangeReadSequenceNumber")
public class ChangeReadSequenceNumberAction
extends ChangeSequenceNumberAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public ChangeReadSequenceNumberAction() {
    }

    public ChangeReadSequenceNumberAction(long sequenceNumber) {
        super(sequenceNumber);
    }

    @Override
    protected void changeSequenceNumber(TlsContext tlsContext) {
        LOGGER.info("Changed read sequence number of current cipher");
        if (tlsContext.getRecordLayer() != null) {
            int epoch = tlsContext.getRecordLayer().getReadEpoch();
            tlsContext.getRecordLayer().getEncryptor().getRecordCipher(epoch).getState().setReadSequenceNumber(this.sequenceNumber);
        }
    }
}

