/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ChangeDefaultPreMasterSecret")
public class ChangeDefaultPreMasterSecretAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] newValue = null;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] oldValue = null;

    public ChangeDefaultPreMasterSecretAction(byte[] newValue) {
        this.newValue = newValue;
    }

    public ChangeDefaultPreMasterSecretAction() {
    }

    public void setNewValue(byte[] newValue) {
        this.newValue = newValue;
    }

    public byte[] getNewValue() {
        return this.newValue;
    }

    public byte[] getOldValue() {
        return this.oldValue;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getContext(this.getConnectionAlias()).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        this.oldValue = tlsContext.getConfig().getDefaultPreMasterSecret();
        tlsContext.getConfig().setDefaultPreMasterSecret(this.newValue);
        LOGGER.info("Changed DefaultPreMasterSecret from {}  in config to {}", (Object)this.oldValue, (Object)this.newValue);
        this.setExecuted(true);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + Arrays.hashCode(this.newValue);
        hash = 11 * hash + Arrays.hashCode(this.oldValue);
        return hash;
    }

    @Override
    public void reset() {
        this.oldValue = null;
        this.setExecuted(null);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeDefaultPreMasterSecretAction other = (ChangeDefaultPreMasterSecretAction)obj;
        if (!Arrays.equals(this.newValue, other.newValue)) {
            return false;
        }
        return Arrays.equals(this.oldValue, other.oldValue);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

