/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ChangeConnectionTimeout")
public class ChangeConnectionTimeoutAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private long newValue;
    private long oldValue;

    public ChangeConnectionTimeoutAction(long newValue) {
        this.newValue = newValue;
    }

    public ChangeConnectionTimeoutAction() {
    }

    public void setNewValue(long newValue) {
        this.newValue = newValue;
    }

    public long getNewValue() {
        return this.newValue;
    }

    public long getOldValue() {
        return this.oldValue;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getContext(this.getConnectionAlias()).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        this.oldValue = tlsContext.getContext().getTransportHandler().getTimeout();
        tlsContext.getContext().getTransportHandler().setTimeout(this.newValue);
        LOGGER.info("Changed Timeout from {} to {}", (Object)this.oldValue, (Object)this.newValue);
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (int)(this.newValue ^ this.newValue >>> 32);
        hash = 53 * hash + (int)(this.oldValue ^ this.oldValue >>> 32);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeConnectionTimeoutAction other = (ChangeConnectionTimeoutAction)obj;
        if (this.newValue != other.newValue) {
            return false;
        }
        return this.oldValue == other.oldValue;
    }
}

