/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.ModifiableVariableField;
import de.rub.nds.protocol.crypto.signature.SignatureComputations;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.modifiableVariable.ModvarHelper;
import de.rub.nds.x509attacker.x509.model.publickey.PublicKeyContent;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.JAXBSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class WorkflowTraceSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static JAXBContext context;

    public static synchronized JAXBContext getJAXBContext() throws JAXBException, IOException {
        if (context == null) {
            String packageName = "de.rub";
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().includePackage(packageName)));
            HashSet<Class<DataContainer>> classes = new HashSet<Class<DataContainer>>();
            classes.add(WorkflowTrace.class);
            classes.addAll(WorkflowTraceSerializer.getSerializableSubTypes(reflections, TlsAction.class));
            classes.addAll(WorkflowTraceSerializer.getSerializableSubTypes(reflections, DataContainer.class));
            classes.addAll(WorkflowTraceSerializer.getSerializableSubTypes(reflections, Asn1Encodable.class));
            classes.addAll(WorkflowTraceSerializer.getSerializableSubTypes(reflections, PublicKeyContent.class));
            classes.addAll(WorkflowTraceSerializer.getSerializableSubTypes(reflections, VariableModification.class));
            classes.addAll(WorkflowTraceSerializer.getSerializableSubTypes(reflections, SignatureComputations.class));
            LOGGER.trace("Registering Classes in JAXBContext of WorkflowTraceSerializer:");
            for (Class clazz : classes) {
                LOGGER.trace(clazz.getName());
            }
            context = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]));
        }
        return context;
    }

    private static <T> Set<Class<? extends T>> getSerializableSubTypes(Reflections reflections, Class<T> clazz) {
        return reflections.getSubTypesOf(clazz).stream().filter(listed -> !listed.isInterface()).collect(Collectors.toSet());
    }

    public static synchronized void setJAXBContext(JAXBContext context) throws JAXBException, IOException {
        WorkflowTraceSerializer.context = context;
    }

    public static void write(File file, WorkflowTrace trace) throws FileNotFoundException, JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            WorkflowTraceSerializer.write(fos, trace);
        }
    }

    public static String write(WorkflowTrace trace) throws JAXBException, IOException {
        SilentByteArrayOutputStream bos = new SilentByteArrayOutputStream();
        WorkflowTraceSerializer.write((OutputStream)bos, trace);
        return bos.toString(StandardCharsets.UTF_8);
    }

    public static void write(OutputStream outputStream, WorkflowTrace workflowTrace) throws JAXBException, IOException {
        context = WorkflowTraceSerializer.getJAXBContext();
        try (SilentByteArrayOutputStream xmlOutputStream = new SilentByteArrayOutputStream();){
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform((Source)new JAXBSource(context, (Object)workflowTrace), new StreamResult((OutputStream)xmlOutputStream));
            outputStream.write(xmlOutputStream.toString(StandardCharsets.UTF_8).replaceAll("\r?\n", System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
        }
        catch (TransformerException E) {
            throw new JAXBException((Throwable)E);
        }
    }

    public static WorkflowTrace insecureRead(InputStream inputStream) throws JAXBException, IOException, XMLStreamException {
        context = WorkflowTraceSerializer.getJAXBContext();
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setEventHandler(event -> false);
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
        return (WorkflowTrace)unmarshaller.unmarshal(xsr);
    }

    public static List<WorkflowTrace> insecureReadFolder(File f) {
        if (f.isDirectory()) {
            ArrayList<WorkflowTrace> list = new ArrayList<WorkflowTrace>();
            File[] files = f.listFiles();
            if (files == null) {
                return list;
            }
            for (File file : files) {
                if (file.getName().startsWith(".")) continue;
                try (FileInputStream fis = new FileInputStream(file);){
                    WorkflowTrace trace = WorkflowTraceSerializer.insecureRead(fis);
                    trace.setName(file.getAbsolutePath());
                    list.add(trace);
                }
                catch (JAXBException | IOException | XMLStreamException ex) {
                    LOGGER.warn("Could not read {} from folder", (Object)file.getAbsolutePath());
                    LOGGER.debug((Object)ex);
                }
            }
            return list;
        }
        throw new IllegalArgumentException("Cannot read Folder, because its not a Folder");
    }

    public static WorkflowTrace secureRead(InputStream inputStream) throws JAXBException, IOException, XMLStreamException {
        try {
            context = WorkflowTraceSerializer.getJAXBContext();
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return false;
                }
            });
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
            WorkflowTrace wt = (WorkflowTrace)unmarshaller.unmarshal(xsr);
            ModvarHelper helper = new ModvarHelper();
            List<ModifiableVariableField> allSentFields = helper.getAllStaticallyConfiguredSentFields(wt);
            for (ModifiableVariableField field : allSentFields) {
                if (field.getModifiableVariable() == null || field.getModifiableVariable().getOriginalValue() == null) continue;
                LOGGER.warn("Your WorkflowTrace still contains original values. These values will be deleted by TLS-Attacker and ignored for any computations. Use Modifications and/or the Config to change the contet of messages");
                break;
            }
            return wt;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<WorkflowTrace> secureReadFolder(File f) {
        if (f.isDirectory()) {
            LOGGER.debug("Reading WorkflowTraces from folder: {}", (Object)f.getAbsolutePath());
            ArrayList<WorkflowTrace> list = new ArrayList<WorkflowTrace>();
            File[] files = f.listFiles();
            if (files == null) {
                return list;
            }
            for (File file : files) {
                if (file.getName().startsWith(".")) continue;
                try (FileInputStream fis = new FileInputStream(file);){
                    LOGGER.debug("Reading WorkflowTrace from file: {}", (Object)file.getAbsolutePath());
                    WorkflowTrace trace = WorkflowTraceSerializer.secureRead(fis);
                    trace.setName(file.getAbsolutePath());
                    list.add(trace);
                }
                catch (JAXBException | IOException | XMLStreamException ex) {
                    LOGGER.warn("Could not read {} from Folder.", ex);
                }
            }
            return list;
        }
        throw new IllegalArgumentException("Cannot read Folder, because its not a Folder");
    }

    private WorkflowTraceSerializer() {
    }
}

