/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceConfigurationUtil;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceMutationException;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTruncationMode;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveTillAction;
import de.rub.nds.tlsattacker.core.workflow.action.StaticReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.StaticSendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkflowTraceMutator {
    private static final Logger LOGGER = LogManager.getLogger();

    private static void replaceMessagesInList(List<ProtocolMessage> messageList, ProtocolMessageType type, ProtocolMessage replaceMessage) {
        if (replaceMessage != null) {
            messageList.replaceAll(message -> {
                if (message.getProtocolMessageType() == type) {
                    return replaceMessage;
                }
                return message;
            });
        } else {
            messageList.removeIf(message -> message.getProtocolMessageType() == type);
        }
    }

    private static void replaceMessagesInList(List<ProtocolMessage> messageList, HandshakeMessageType type, ProtocolMessage replacementMessage) {
        if (replacementMessage != null) {
            messageList.replaceAll(message -> {
                if (message instanceof HandshakeMessage && ((HandshakeMessage)message).getHandshakeMessageType() == type) {
                    return replacementMessage;
                }
                return message;
            });
        } else {
            messageList.removeIf(message -> message instanceof HandshakeMessage && ((HandshakeMessage)message).getHandshakeMessageType() == type);
        }
    }

    public static void replaceStaticSendingMessage(WorkflowTrace trace, ProtocolMessageType type, ProtocolMessage replacementMessage) {
        List<StaticSendingAction> sendingActions = WorkflowTraceConfigurationUtil.getStaticSendingActionsWithConfiguration(trace, type);
        ArrayList<StaticSendingAction> deleteActions = new ArrayList<StaticSendingAction>();
        for (StaticSendingAction staticSendingAction : sendingActions) {
            List<ProtocolMessage> messages = staticSendingAction.getConfiguredList(ProtocolMessage.class);
            WorkflowTraceMutator.replaceMessagesInList(messages, type, replacementMessage);
            if (!messages.isEmpty()) continue;
            deleteActions.add(staticSendingAction);
        }
        Iterator<TlsAction> iterator = trace.getTlsActions().iterator();
        block1: while (iterator.hasNext()) {
            TlsAction tlsAction = iterator.next();
            for (StaticSendingAction staticSendingAction : deleteActions) {
                if (tlsAction != staticSendingAction) continue;
                iterator.remove();
                continue block1;
            }
        }
    }

    public static void replaceStaticSendingMessage(WorkflowTrace trace, HandshakeMessageType type, HandshakeMessage replacementMessage) {
        List<StaticSendingAction> sendingActions = WorkflowTraceConfigurationUtil.getStaticSendingActionsWithConfiguration(trace, type);
        ArrayList<StaticSendingAction> deleteActions = new ArrayList<StaticSendingAction>();
        for (StaticSendingAction staticSendingAction : sendingActions) {
            List<ProtocolMessage> messages = staticSendingAction.getConfiguredList(ProtocolMessage.class);
            WorkflowTraceMutator.replaceMessagesInList(messages, type, (ProtocolMessage)replacementMessage);
            if (!messages.isEmpty()) continue;
            deleteActions.add(staticSendingAction);
        }
        Iterator<TlsAction> iterator = trace.getTlsActions().iterator();
        block1: while (iterator.hasNext()) {
            TlsAction tlsAction = iterator.next();
            for (StaticSendingAction staticSendingAction : deleteActions) {
                if (tlsAction != staticSendingAction) continue;
                iterator.remove();
                continue block1;
            }
        }
    }

    public static void deleteSendingMessage(WorkflowTrace trace, ProtocolMessageType type) {
        WorkflowTraceMutator.replaceStaticSendingMessage(trace, type, null);
    }

    public static void deleteSendingMessage(WorkflowTrace trace, HandshakeMessageType type) {
        WorkflowTraceMutator.replaceStaticSendingMessage(trace, type, null);
    }

    public static void replaceReceivingMessage(@Nonnull WorkflowTrace trace, @Nonnull ProtocolMessageType type, @Nullable ProtocolMessage replaceMessage) throws WorkflowTraceMutationException {
        List<StaticReceivingAction> receivingActions = WorkflowTraceConfigurationUtil.getStaticReceivingActionsWithConfiguration(trace, type);
        ArrayList<StaticReceivingAction> deleteActions = new ArrayList<StaticReceivingAction>();
        for (StaticReceivingAction staticReceivingAction : receivingActions) {
            if (staticReceivingAction instanceof ReceiveAction) {
                List<ProtocolMessage> messages = ((ReceiveAction)staticReceivingAction).getExpectedMessages();
                WorkflowTraceMutator.replaceMessagesInList(messages, type, replaceMessage);
                if (!messages.isEmpty()) continue;
                deleteActions.add(staticReceivingAction);
                continue;
            }
            if (staticReceivingAction instanceof ReceiveTillAction) {
                ProtocolMessage message = ((ReceiveTillAction)((Object)staticReceivingAction)).getWaitTillMessage();
                if (message.getProtocolMessageType() != type) continue;
                if (replaceMessage == null) {
                    throw new WorkflowTraceMutationException("ReceiveTillAction cannot be deleted, because this will probably break your workflow.");
                }
                ((ReceiveTillAction)((Object)staticReceivingAction)).setWaitTillMessage(replaceMessage);
                continue;
            }
            throw new WorkflowTraceMutationException("Unsupported ReceivingAction, could not mutate workflow.");
        }
        Iterator<TlsAction> iterator = trace.getTlsActions().iterator();
        block1: while (iterator.hasNext()) {
            TlsAction tlsAction = iterator.next();
            for (StaticReceivingAction staticReceivingAction : deleteActions) {
                if (tlsAction != staticReceivingAction) continue;
                iterator.remove();
                continue block1;
            }
        }
    }

    public static void replaceReceivingMessage(@Nonnull WorkflowTrace trace, @Nonnull HandshakeMessageType type, @Nullable ProtocolMessage replaceMessage) {
        List<StaticReceivingAction> receivingActions = WorkflowTraceConfigurationUtil.getStaticReceivingActionsWithConfiguration(trace, type);
        ArrayList<StaticReceivingAction> deleteActions = new ArrayList<StaticReceivingAction>();
        for (StaticReceivingAction staticReceivingAction : receivingActions) {
            List<ProtocolMessage> messages = staticReceivingAction.getExpectedList(ProtocolMessage.class);
            WorkflowTraceMutator.replaceMessagesInList(messages, type, replaceMessage);
            if (!messages.isEmpty()) continue;
            deleteActions.add(staticReceivingAction);
        }
        Iterator<TlsAction> iterator = trace.getTlsActions().iterator();
        block1: while (iterator.hasNext()) {
            TlsAction tlsAction = iterator.next();
            for (StaticReceivingAction staticReceivingAction : deleteActions) {
                if (tlsAction != staticReceivingAction) continue;
                iterator.remove();
                continue block1;
            }
        }
    }

    public static void deleteReceivingMessage(WorkflowTrace trace, ProtocolMessageType type) throws WorkflowTraceMutationException {
        WorkflowTraceMutator.replaceReceivingMessage(trace, type, null);
    }

    public static void deleteReceivingMessage(WorkflowTrace trace, HandshakeMessageType type) throws WorkflowTraceMutationException {
        WorkflowTraceMutator.replaceReceivingMessage(trace, type, null);
    }

    private static int getTruncationActionIndex(WorkflowTrace trace, ProtocolMessageType type, boolean sending, boolean untilLast) {
        int i;
        int n = i = untilLast ? trace.getTlsActions().size() - 1 : 0;
        while (untilLast ? i >= 0 : i < trace.getTlsActions().size()) {
            TlsAction action = trace.getTlsActions().get(i);
            if (action instanceof StaticReceivingAction && !sending) {
                messages = ((StaticReceivingAction)((Object)action)).getExpectedList(ProtocolMessage.class);
                for (ProtocolMessage message : messages) {
                    if (message.getProtocolMessageType() != type) continue;
                    return i;
                }
            } else if (action instanceof StaticSendingAction && sending) {
                messages = ((StaticSendingAction)((Object)action)).getConfiguredList(ProtocolMessage.class);
                for (ProtocolMessage message : messages) {
                    if (message.getProtocolMessageType() != type) continue;
                    return i;
                }
            }
            i += untilLast ? -1 : 1;
        }
        return -1;
    }

    private static int getTruncationActionIndex(WorkflowTrace trace, HandshakeMessageType type, boolean sending, boolean untilLast) {
        int i;
        int n = i = untilLast ? trace.getTlsActions().size() - 1 : 0;
        while (untilLast ? i >= 0 : i < trace.getTlsActions().size()) {
            TlsAction action = trace.getTlsActions().get(i);
            if (action instanceof StaticReceivingAction && !sending) {
                messages = ((StaticReceivingAction)((Object)action)).getExpectedList(ProtocolMessage.class);
                for (ProtocolMessage message : messages) {
                    if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
                    return i;
                }
            } else if (action instanceof StaticSendingAction && sending) {
                messages = ((StaticSendingAction)((Object)action)).getConfiguredList(ProtocolMessage.class);
                for (ProtocolMessage message : messages) {
                    if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
                    return i;
                }
            }
            i += untilLast ? -1 : 1;
        }
        return -1;
    }

    private static void truncate(WorkflowTrace trace, ProtocolMessageType type, WorkflowTruncationMode mode, boolean sending, boolean untilLast) {
        int truncationIndex = WorkflowTraceMutator.getTruncationActionIndex(trace, type, sending, untilLast);
        if (truncationIndex < 0) {
            LOGGER.warn("Could not truncate WorkflowTrace. Message: {} not found.", (Object)type);
            return;
        }
        TlsAction action = trace.getTlsActions().get(truncationIndex);
        List<Object> messages = new ArrayList();
        if (action instanceof StaticSendingAction) {
            messages = ((StaticSendingAction)((Object)action)).getConfiguredList(ProtocolMessage.class);
        } else if (action instanceof StaticReceivingAction) {
            messages = ((StaticReceivingAction)((Object)action)).getExpectedList(ProtocolMessage.class);
        }
        int messageIndex = -1;
        for (int i = 0; i < messages.size(); ++i) {
            if (((ProtocolMessage)messages.get(i)).getProtocolMessageType() != type) continue;
            messageIndex = i;
            if (mode == WorkflowTruncationMode.AFTER) {
                ++messageIndex;
            }
            if (!untilLast) break;
        }
        if (messageIndex < 0) {
            LOGGER.error("Could not truncate WorkflowTrace. Message: {} not found. Messages(size): {}", (Object)type, (Object)messages.size());
            return;
        }
        messages.subList(messageIndex, messages.size()).clear();
        if (messages.isEmpty()) {
            trace.getTlsActions().subList(truncationIndex, trace.getTlsActions().size()).clear();
        } else {
            trace.getTlsActions().subList(truncationIndex + 1, trace.getTlsActions().size()).clear();
        }
    }

    private static void truncate(WorkflowTrace trace, HandshakeMessageType type, WorkflowTruncationMode mode, boolean sending, boolean untilLast) {
        int truncationIndex = WorkflowTraceMutator.getTruncationActionIndex(trace, type, sending, untilLast);
        if (truncationIndex < 0) {
            LOGGER.warn("Could not truncate WorkflowTrace. Message: {} not found.", (Object)type);
            return;
        }
        TlsAction action = trace.getTlsActions().get(truncationIndex);
        List<Object> messages = new ArrayList();
        if (action instanceof StaticSendingAction) {
            messages = ((StaticSendingAction)((Object)action)).getConfiguredList(ProtocolMessage.class);
        } else if (action instanceof StaticReceivingAction) {
            messages = ((StaticReceivingAction)((Object)action)).getExpectedList(ProtocolMessage.class);
        }
        int messageIndex = -1;
        for (int i = 0; i < messages.size(); ++i) {
            ProtocolMessage message = (ProtocolMessage)messages.get(i);
            if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
            messageIndex = i;
            if (mode == WorkflowTruncationMode.AFTER) {
                ++messageIndex;
            }
            if (!untilLast) break;
        }
        if (messageIndex < 0) {
            LOGGER.error("Could not truncate WorkflowTrace. Message: {} not found.", (Object)type);
            return;
        }
        messages.subList(messageIndex, messages.size()).clear();
        if (messages.isEmpty()) {
            trace.getTlsActions().subList(truncationIndex, trace.getTlsActions().size()).clear();
        } else {
            trace.getTlsActions().subList(truncationIndex + 1, trace.getTlsActions().size()).clear();
        }
    }

    public static void truncateAt(WorkflowTrace trace, HandshakeMessageType type, boolean sending, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AT, sending, untilLast);
    }

    public static void truncateAt(WorkflowTrace trace, ProtocolMessageType type, boolean sending, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AT, sending, untilLast);
    }

    public static void truncateSendingAt(WorkflowTrace trace, HandshakeMessageType type, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AT, true, untilLast);
    }

    public static void truncateSendingAt(WorkflowTrace trace, ProtocolMessageType type, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AT, true, untilLast);
    }

    public static void truncateReceivingAt(WorkflowTrace trace, HandshakeMessageType type, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AT, false, untilLast);
    }

    public static void truncateReceivingAt(WorkflowTrace trace, ProtocolMessageType type, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AT, false, untilLast);
    }

    public static void truncateSendingAfter(WorkflowTrace trace, HandshakeMessageType type, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AFTER, true, untilLast);
    }

    public static void truncateSendingAfter(WorkflowTrace trace, ProtocolMessageType type, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AFTER, true, untilLast);
    }

    public static void truncateReceivingAfter(WorkflowTrace trace, HandshakeMessageType type, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AFTER, false, untilLast);
    }

    public static void truncateReceivingAfter(WorkflowTrace trace, ProtocolMessageType type, boolean untilLast) {
        WorkflowTraceMutator.truncate(trace, type, WorkflowTruncationMode.AFTER, false, untilLast);
    }
}

