/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.protocol.exception.PreparationException;
import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.protocol.message.ack.RecordNumber;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DTLSWorkflowExecutor
extends WorkflowExecutor {
    private static final Logger LOGGER = LogManager.getLogger();

    public DTLSWorkflowExecutor(State state) {
        super(WorkflowExecutorType.DTLS, state);
    }

    @Override
    public void executeWorkflow() throws WorkflowExecutionException {
        LOGGER.debug("Starting execution of WorkflowTrace");
        if (this.config.isWorkflowExecutorShouldOpen().booleanValue()) {
            try {
                this.initAllLayer();
            }
            catch (IOException ex) {
                throw new WorkflowExecutionException("Workflow not executed, could not initialize transport handler: ", (Throwable)ex);
            }
        }
        this.state.getWorkflowTrace().reset();
        this.state.setStartTimestamp(System.currentTimeMillis());
        List<TlsAction> tlsActions = this.state.getWorkflowTrace().getTlsActions();
        int retransmissions = 0;
        int index = 0;
        while (index < tlsActions.size()) {
            TlsAction action = tlsActions.get(index);
            if (!action.isExecuted()) {
                LOGGER.trace("Executing regular action {} at index {}", (Object)action, (Object)index);
                try {
                    action.execute(this.state);
                }
                catch (UnsupportedOperationException E) {
                    LOGGER.warn("Unsupported operation!", (Throwable)E);
                    this.state.setExecutionException(E);
                }
                catch (PreparationException | WorkflowExecutionException ex) {
                    this.state.setExecutionException(ex);
                    throw new WorkflowExecutionException("Problem while executing Action:" + action.toString(), ex);
                }
                catch (Exception e) {
                    this.state.setExecutionException(e);
                    throw e;
                }
                finally {
                    this.state.setEndTimestamp(System.currentTimeMillis());
                }
            }
            if (this.config.isStopActionsAfterFatal().booleanValue() && this.isReceivedFatalAlert()) {
                LOGGER.debug("Skipping all Actions, received FatalAlert, StopActionsAfterFatal active");
                break;
            }
            if (this.config.getStopActionsAfterWarning().booleanValue() && this.isReceivedWarningAlert()) {
                LOGGER.debug("Skipping all Actions, received Warning Alert, StopActionsAfterWarning active");
                break;
            }
            if (this.config.getStopActionsAfterIOException().booleanValue() && this.isIoException()) {
                LOGGER.debug("Skipping all Actions, received IO Exception, StopActionsAfterIOException active");
                break;
            }
            if (!action.executedAsPlanned() && action instanceof ReceivingAction) {
                if (this.config.isStopTraceAfterUnexpected().booleanValue()) {
                    LOGGER.debug("Skipping all Actions, action did not execute as planned.");
                    break;
                }
                if (retransmissions == this.config.getMaxUDPRetransmissions()) {
                    LOGGER.debug("Hit max retransmissions, stopping workflow");
                    break;
                }
                LOGGER.trace("Stepping back index to perform retransmission. From index: {}", (Object)index);
                try {
                    this.performRetransmissions(tlsActions, index);
                }
                catch (IOException E) {
                    LOGGER.warn("IOException occured during retransmission. Stopping workflow.", (Throwable)E);
                    break;
                }
                action.reset();
                ++retransmissions;
                continue;
            }
            ++index;
        }
        if (this.config.isFinishWithCloseNotify().booleanValue()) {
            for (Context context : this.state.getAllContexts()) {
                int currentEpoch;
                for (int epoch = currentEpoch = context.getTlsContext().getRecordLayer().getWriteEpoch(); epoch >= 0; --epoch) {
                    context.getTlsContext().getRecordLayer().setWriteEpoch(epoch);
                    if (this.state.getTlsContext().getRecordLayer().getEncryptor().getRecordCipher(epoch) == null) {
                        LOGGER.debug("Not sending a Close Notify for epoch {}. No cipher available.", (Object)epoch);
                        continue;
                    }
                    this.sendCloseNotify(context.getTlsContext());
                }
                context.getTlsContext().getRecordLayer().setWriteEpoch(currentEpoch);
            }
        }
        this.setFinalSocketState();
        if (this.config.isWorkflowExecutorShouldClose().booleanValue()) {
            this.closeConnection();
        }
        if (this.config.isResetWorkflowTracesBeforeSaving().booleanValue()) {
            LOGGER.debug("Resetting WorkflowTrace");
            this.state.getWorkflowTrace().reset();
        }
        if (this.getAfterExecutionCallback() != null) {
            LOGGER.debug("Executing AfterExecutionCallback");
            try {
                this.getAfterExecutionCallback().apply(this.state);
            }
            catch (Exception ex) {
                LOGGER.trace("Error during AfterExecutionCallback", (Throwable)ex);
            }
        }
    }

    private void performRetransmissions(List<TlsAction> tlsActions, int receiveActionIndex) throws IOException {
        int retransmissionIndex;
        if (!(tlsActions.get(receiveActionIndex) instanceof ReceivingAction)) {
            throw new WorkflowExecutionException("Passed index of non receiving action as index. Index: " + receiveActionIndex + ", Type: " + tlsActions.get(receiveActionIndex).getClass().getSimpleName());
        }
        ReceivingAction receivingAction = (ReceivingAction)((Object)tlsActions.get(receiveActionIndex));
        Set<String> receivingAliases = receivingAction.getAllReceivingAliases();
        for (int i = retransmissionIndex = this.findRetransmissionIndex(tlsActions, receiveActionIndex); i < receiveActionIndex; ++i) {
            SendingAction sendingAction;
            TlsAction action = tlsActions.get(i);
            if (!(action instanceof SendingAction) || (sendingAction = (SendingAction)((Object)action)).getAllSendingAliases() == null || Collections.disjoint(receivingAliases, sendingAction.getAllSendingAliases())) continue;
            LOGGER.debug("Performing retransmission for action {}", (Object)sendingAction);
            this.executeRetransmission(sendingAction);
        }
    }

    private int findRetransmissionIndex(List<TlsAction> tlsActions, int index) {
        if (!(tlsActions.get(index) instanceof ReceivingAction)) {
            throw new WorkflowExecutionException("Passed index of non receiving action as index");
        }
        ReceivingAction receivingAction = (ReceivingAction)((Object)tlsActions.get(index));
        Set<String> aliases = receivingAction.getAllReceivingAliases();
        for (int i = index - 1; i >= 0; --i) {
            TlsAction action = tlsActions.get(i);
            if (!(action instanceof ReceivingAction)) continue;
            for (String alias : action.getAllAliases()) {
                if (!aliases.contains(alias)) continue;
                return i;
            }
            return i;
        }
        return 0;
    }

    private void executeRetransmission(SendingAction action) throws IOException {
        LOGGER.debug("Executing retransmission for {}", (Object)action.getClass().getSimpleName());
        for (String alias : action.getAllSendingAliases()) {
            LOGGER.debug("Retransmitting records for alias {}", (Object)alias);
            List<Record> recordsToRetransmit = this.config.getRetransmitAcknowledgedRecordsInDtls13() != false ? action.getSentRecords() : this.filterRecordsBasedOnAcks(action.getSentRecords());
            this.state.getTlsContext(alias).getRecordLayer().setLayerConfiguration(new SpecificSendLayerConfiguration<Record>((LayerType)ImplementedLayers.RECORD, recordsToRetransmit));
            try {
                this.state.getTlsContext(alias).getRecordLayer().sendConfiguration();
            }
            catch (IOException ex) {
                this.state.getTlsContext(alias).setReceivedTransportHandlerException(true);
                LOGGER.warn("Received IOException during retransmission", (Throwable)ex);
            }
        }
    }

    private List<Record> filterRecordsBasedOnAcks(List<Record> sendRecords) {
        List<RecordNumber> acks = this.state.getTlsContext().getDtls13ReceivedAcknowledgedRecords();
        if (acks == null || acks.isEmpty()) {
            return sendRecords;
        }
        return sendRecords.stream().filter(record -> !acks.contains((Object)new RecordNumber(BigInteger.valueOf(((Integer)((Record)sendRecords.get(0)).getEpoch().getValue()).intValue()), (BigInteger)record.getSequenceNumber().getValue()))).collect(Collectors.toList());
    }
}

