/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.util;

import de.rub.nds.protocol.crypto.key.PublicKeyContainer;
import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveTillAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.x509attacker.x509.X509CertificateChain;
import java.io.IOException;
import java.security.cert.CertificateParsingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateFetcher {
    private static final Logger LOGGER = LogManager.getLogger();

    public static PublicKeyContainer fetchServerPublicKey(Config config) throws CertificateParsingException {
        X509CertificateChain fetchedServerCertificateChain = CertificateFetcher.fetchServerCertificateChain(config);
        if (fetchedServerCertificateChain != null && !fetchedServerCertificateChain.getCertificateList().isEmpty()) {
            return fetchedServerCertificateChain.getLeaf().getPublicKeyContainer();
        }
        return null;
    }

    public static X509CertificateChain fetchServerCertificateChain(Config config) {
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowTrace(config.getDefaultClientConnection());
        trace.addTlsAction(new SendAction(new ClientHelloMessage(config)));
        if (config.getHighestProtocolVersion().isDTLS()) {
            trace.addTlsAction(new ReceiveAction(new HelloVerifyRequestMessage()));
            trace.addTlsAction(new SendAction(new ClientHelloMessage(config)));
        }
        trace.addTlsAction(new ReceiveTillAction(new CertificateMessage()));
        State state = new State(config, trace);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(config.getWorkflowExecutorType(), state);
        try {
            workflowExecutor.executeWorkflow();
            if (!state.getContext().getTransportHandler().isClosed()) {
                state.getContext().getTransportHandler().closeConnection();
            }
        }
        catch (WorkflowExecutionException | IOException e) {
            LOGGER.warn("Could not fetch ServerCertificate", e);
        }
        return state.getTlsContext().getServerCertificateChain();
    }

    private CertificateFetcher() {
    }
}

