/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.udp;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.udp.UdpDataPacketHandler;
import de.rub.nds.tlsattacker.core.udp.UdpDataPacketParser;
import de.rub.nds.tlsattacker.core.udp.UdpDataPacketPreparator;
import de.rub.nds.tlsattacker.core.udp.UdpDataPacketSerializer;
import java.io.InputStream;

public class UdpDataPacket
implements DataContainer {
    private String sourceIp;
    private String destinationIp;
    private Integer sourcePort;
    private Integer destinationPort;
    private transient byte[] configData;
    private ModifiableByteArray data;

    public UdpDataPacket() {
    }

    public UdpDataPacket(byte[] configData) {
        this.configData = configData;
    }

    public ModifiableByteArray getData() {
        return this.data;
    }

    public void setData(ModifiableByteArray data) {
        this.data = data;
    }

    public void setData(byte[] data) {
        this.data = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.data, (byte[])data);
    }

    public UdpDataPacketParser getParser(Context context, InputStream stream) {
        return new UdpDataPacketParser(stream);
    }

    public UdpDataPacketPreparator getPreparator(Context context) {
        return new UdpDataPacketPreparator(context.getChooser(), this);
    }

    public UdpDataPacketSerializer getSerializer(Context context) {
        return new UdpDataPacketSerializer(this);
    }

    public UdpDataPacketHandler getHandler(Context context) {
        return new UdpDataPacketHandler();
    }

    public byte[] getConfigData() {
        return this.configData;
    }

    public void setConfigData(byte[] configData) {
        this.configData = configData;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
    }

    public String getDestinationIp() {
        return this.destinationIp;
    }

    public void setDestinationIp(String destinationIp) {
        this.destinationIp = destinationIp;
    }

    public Integer getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(Integer sourcePort) {
        this.sourcePort = sourcePort;
    }

    public Integer getDestinationPort() {
        return this.destinationPort;
    }

    public void setDestinationPort(Integer destinationPort) {
        this.destinationPort = destinationPort;
    }

    public String toString() {
        if (this.sourceIp == null || this.sourcePort == null || this.destinationIp == null || this.destinationPort == null) {
            return "UdpDataPacket";
        }
        return "UdpDataPacket [src: " + this.sourceIp + ":" + this.sourcePort + ", dst:" + this.destinationIp + ":" + this.destinationPort + "]";
    }
}

