/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state.quic;

import de.rub.nds.modifiablevariable.util.RandomHelper;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.layer.context.LayerContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParameters;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.constants.QuicVersion;
import de.rub.nds.tlsattacker.core.quic.frame.ConnectionCloseFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacketCryptoComputations;
import de.rub.nds.tlsattacker.core.state.Context;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuicContext
extends LayerContext {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final byte[] DEFAULT_INITIAL_PACKET_TOKEN = new byte[0];
    public static final int DEFAULT_INITIAL_PACKET_NUMBER = 0;
    private QuicVersion quicVersion;
    private byte[] firstDestinationConnectionId;
    private byte[] destinationConnectionId;
    private byte[] sourceConnectionId;
    private byte[] initialPacketToken = DEFAULT_INITIAL_PACKET_TOKEN;
    private QuicTransportParameters receivedTransportParameters;
    private byte[] initialSalt;
    private HKDFAlgorithm initialHKDFAlgorithm;
    private Cipher initialAeadCipher;
    private Cipher initalHeaderProtectionCipher;
    private CipherSuite initialCipherSuite;
    private HKDFAlgorithm zeroRTTHKDFAlgorithm;
    private Cipher zeroRTTAeadCipher;
    private Cipher zeroRTTHeaderProtectionCipher;
    private CipherSuite zeroRTTCipherSuite;
    private HKDFAlgorithm hkdfAlgorithm;
    private Cipher aeadCipher;
    private Cipher headerProtectionCipher;
    private boolean initialSecretsInitialized;
    private byte[] initialSecret;
    private byte[] initialClientSecret;
    private byte[] initialServerSecret;
    private byte[] initialClientKey;
    private byte[] initialServerKey;
    private byte[] initialClientIv;
    private byte[] initialServerIv;
    private byte[] initialClientHeaderProtectionKey;
    private byte[] initialServerHeaderProtectionKey;
    private boolean handshakeSecretsInitialized;
    private byte[] handshakeClientSecret;
    private byte[] handshakeServerSecret;
    private byte[] handshakeClientKey;
    private byte[] handshakeServerKey;
    private byte[] handshakeClientIv;
    private byte[] handshakeServerIv;
    private byte[] handshakeClientHeaderProtectionKey;
    private byte[] handshakeServerHeaderProtectionKey;
    private boolean applicationSecretsInitialized;
    private byte[] applicationClientSecret;
    private byte[] applicationServerSecret;
    private byte[] applicationClientKey;
    private byte[] applicationServerKey;
    private byte[] applicationClientIv;
    private byte[] applicationServerIv;
    private byte[] applicationClientHeaderProtectionKey;
    private byte[] applicationServerHeaderProtectionKey;
    private boolean zeroRTTSecretsInitialized;
    private byte[] zeroRTTClientSecret;
    private byte[] zeroRTTServerSecret;
    private byte[] zeroRTTClientKey;
    private byte[] zeroRTTServerKey;
    private byte[] zeroRTTClientIv;
    private byte[] zeroRTTServerIv;
    private byte[] zeroRTTClientHeaderProtectionKey;
    private byte[] zeroRTTServerHeaderProtectionKey;
    private int initialPacketPacketNumber = 0;
    private int handshakePacketPacketNumber = 0;
    private int oneRTTPacketPacketNumber = 0;
    private LinkedList<QuicPacketType> receivedPackets = new LinkedList();
    private final LinkedList<Integer> receivedInitialPacketNumbers = new LinkedList();
    private final LinkedList<Integer> receivedHandshakePacketNumbers = new LinkedList();
    private final LinkedList<Integer> receivedOneRTTPacketNumbers = new LinkedList();
    private List<byte[]> supportedVersions = new ArrayList<byte[]>();
    private ConnectionCloseFrame receivedConnectionCloseFrame;
    private byte[] pathChallengeData;

    public QuicContext(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.quicVersion = context.getConfig().getQuicVersion();
        this.initialSalt = this.quicVersion.getInitialSalt();
        this.initialCipherSuite = CipherSuite.TLS_AES_128_GCM_SHA256;
        this.initialHKDFAlgorithm = AlgorithmResolver.getHKDFAlgorithm(this.getInitialCipherSuite());
        try {
            this.initialAeadCipher = Cipher.getInstance("AES/GCM/NoPadding");
            this.initalHeaderProtectionCipher = Cipher.getInstance("AES/ECB/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        this.sourceConnectionId = this.generateRandomConnectionId(16);
        this.firstDestinationConnectionId = this.generateRandomConnectionId(16);
        this.destinationConnectionId = this.firstDestinationConnectionId;
        try {
            QuicPacketCryptoComputations.calculateInitialSecrets(this);
        }
        catch (CryptoException | NoSuchAlgorithmException e) {
            LOGGER.error("Could not initialize initial secrets: ", e);
        }
    }

    private byte[] generateRandomConnectionId(int length) {
        byte[] arr = new byte[length];
        RandomHelper.getRandom().nextBytes(arr);
        return arr;
    }

    public void reset() {
        this.init(this.getContext());
        this.hkdfAlgorithm = null;
        this.aeadCipher = null;
        this.headerProtectionCipher = null;
        this.handshakeClientSecret = null;
        this.handshakeServerSecret = null;
        this.handshakeClientKey = null;
        this.handshakeServerKey = null;
        this.handshakeClientIv = null;
        this.handshakeServerIv = null;
        this.handshakeClientHeaderProtectionKey = null;
        this.handshakeServerHeaderProtectionKey = null;
        this.handshakeSecretsInitialized = false;
        this.applicationClientSecret = null;
        this.applicationServerSecret = null;
        this.applicationClientKey = null;
        this.applicationServerKey = null;
        this.applicationClientIv = null;
        this.applicationServerIv = null;
        this.applicationClientHeaderProtectionKey = null;
        this.applicationServerHeaderProtectionKey = null;
        this.applicationSecretsInitialized = false;
        this.zeroRTTClientSecret = null;
        this.zeroRTTServerSecret = null;
        this.zeroRTTClientKey = null;
        this.zeroRTTServerKey = null;
        this.zeroRTTClientIv = null;
        this.zeroRTTServerIv = null;
        this.zeroRTTClientHeaderProtectionKey = null;
        this.zeroRTTServerHeaderProtectionKey = null;
        this.zeroRTTSecretsInitialized = false;
        this.initialPacketPacketNumber = 0;
        this.handshakePacketPacketNumber = 0;
        this.oneRTTPacketPacketNumber = 0;
        this.receivedPackets.clear();
        this.receivedInitialPacketNumbers.clear();
        this.receivedHandshakePacketNumbers.clear();
        this.receivedOneRTTPacketNumbers.clear();
        this.supportedVersions.clear();
        this.receivedConnectionCloseFrame = null;
    }

    public int getOneRTTPacketPacketNumber() {
        return this.oneRTTPacketPacketNumber;
    }

    public void setOneRTTPacketPacketNumber(int oneRTTPacketPacketNumber) {
        this.oneRTTPacketPacketNumber = oneRTTPacketPacketNumber;
    }

    public byte[] getFirstDestinationConnectionId() {
        return this.firstDestinationConnectionId;
    }

    public void setFirstDestinationConnectionId(byte[] firstDestinationConnectionId) {
        this.firstDestinationConnectionId = firstDestinationConnectionId;
    }

    public byte[] getDestinationConnectionId() {
        return this.destinationConnectionId;
    }

    public void setDestinationConnectionId(byte[] destinationConnectionId) {
        this.destinationConnectionId = destinationConnectionId;
    }

    public byte[] getSourceConnectionId() {
        return this.sourceConnectionId;
    }

    public void setSourceConnectionId(byte[] sourceConnectionId) {
        this.sourceConnectionId = sourceConnectionId;
    }

    public void setInitialHKDFAlgorithm(HKDFAlgorithm hkdfAlgorithm) {
        this.initialHKDFAlgorithm = hkdfAlgorithm;
    }

    public HKDFAlgorithm getInitialHKDFAlgorithm() {
        return this.initialHKDFAlgorithm;
    }

    public byte[] getInitialPacketToken() {
        return this.initialPacketToken;
    }

    public void setInitialPacketToken(byte[] initialPacketToken) {
        this.initialPacketToken = initialPacketToken;
    }

    public void addReceivedInitialPacketNumber(int packetNumber) {
        this.receivedInitialPacketNumbers.add(packetNumber);
        this.receivedInitialPacketNumbers.sort(Comparator.comparingInt(Integer::intValue));
    }

    public LinkedList<Integer> getReceivedInitialPacketNumbers() {
        return this.receivedInitialPacketNumbers;
    }

    public void addReceivedHandshakePacketNumber(int packetNumber) {
        this.receivedHandshakePacketNumbers.add(packetNumber);
        this.receivedHandshakePacketNumbers.sort(Comparator.comparingInt(Integer::intValue));
    }

    public LinkedList<Integer> getReceivedHandshakePacketNumbers() {
        return this.receivedHandshakePacketNumbers;
    }

    public void addReceivedOneRTTPacketNumber(int packetNumber) {
        this.receivedOneRTTPacketNumbers.add(packetNumber);
        this.receivedOneRTTPacketNumbers.sort(Comparator.comparingInt(Integer::intValue));
    }

    public LinkedList<Integer> getReceivedOneRTTPacketNumbers() {
        return this.receivedOneRTTPacketNumbers;
    }

    public int getHandshakePacketPacketNumber() {
        return this.handshakePacketPacketNumber;
    }

    public void setHandshakePacketPacketNumber(int handshakePacketPacketNumber) {
        this.handshakePacketPacketNumber = handshakePacketPacketNumber;
    }

    public int getInitialPacketPacketNumber() {
        return this.initialPacketPacketNumber;
    }

    public void setInitialPacketPacketNumber(int initialPacketPacketNumber) {
        this.initialPacketPacketNumber = initialPacketPacketNumber;
    }

    public byte[] getInitialSalt() {
        return this.initialSalt;
    }

    public CipherSuite getInitialCipherSuite() {
        return this.initialCipherSuite;
    }

    public Cipher getInitialAeadCipher() {
        return this.initialAeadCipher;
    }

    public QuicVersion getQuicVersion() {
        return this.quicVersion;
    }

    public QuicTransportParameters getReceivedTransportParameters() {
        return this.receivedTransportParameters;
    }

    public void setReceivedTransportParameters(QuicTransportParameters receivedTransportParameters) {
        this.receivedTransportParameters = receivedTransportParameters;
    }

    public LinkedList<QuicPacketType> getReceivedPackets() {
        return this.receivedPackets;
    }

    public void setReceivedPackets(LinkedList<QuicPacketType> receivedPackets) {
        this.receivedPackets = receivedPackets;
    }

    public boolean isInitialSecretsInitialized() {
        return this.initialSecretsInitialized;
    }

    public void setInitialSecretsInitialized(boolean initialSecretsInitialized) {
        this.initialSecretsInitialized = initialSecretsInitialized;
    }

    public byte[] getInitialSecret() {
        return this.initialSecret;
    }

    public void setInitialSecret(byte[] initialSecret) {
        this.initialSecret = initialSecret;
    }

    public byte[] getInitialClientSecret() {
        return this.initialClientSecret;
    }

    public void setInitialClientSecret(byte[] initialClientSecret) {
        this.initialClientSecret = initialClientSecret;
    }

    public byte[] getInitialServerSecret() {
        return this.initialServerSecret;
    }

    public void setInitialServerSecret(byte[] initialServerSecret) {
        this.initialServerSecret = initialServerSecret;
    }

    public byte[] getInitialClientKey() {
        return this.initialClientKey;
    }

    public void setInitialClientKey(byte[] initialClientKey) {
        this.initialClientKey = initialClientKey;
    }

    public byte[] getInitialServerKey() {
        return this.initialServerKey;
    }

    public void setInitialServerKey(byte[] initialServerKey) {
        this.initialServerKey = initialServerKey;
    }

    public byte[] getInitialClientIv() {
        return this.initialClientIv;
    }

    public void setInitialClientIv(byte[] initialClientIv) {
        this.initialClientIv = initialClientIv;
    }

    public byte[] getInitialServerIv() {
        return this.initialServerIv;
    }

    public void setInitialServerIv(byte[] initialServerIv) {
        this.initialServerIv = initialServerIv;
    }

    public byte[] getInitialClientHeaderProtectionKey() {
        return this.initialClientHeaderProtectionKey;
    }

    public void setInitialClientHeaderProtectionKey(byte[] initialClientHeaderProtectionKey) {
        this.initialClientHeaderProtectionKey = initialClientHeaderProtectionKey;
    }

    public byte[] getInitialServerHeaderProtectionKey() {
        return this.initialServerHeaderProtectionKey;
    }

    public void setInitialServerHeaderProtectionKey(byte[] initialServerHeaderProtectionKey) {
        this.initialServerHeaderProtectionKey = initialServerHeaderProtectionKey;
    }

    public boolean isHandshakeSecretsInitialized() {
        return this.handshakeSecretsInitialized;
    }

    public void setHandshakeSecretsInitialized(boolean handshakeSecretsInitialized) {
        this.handshakeSecretsInitialized = handshakeSecretsInitialized;
    }

    public byte[] getHandshakeClientSecret() {
        return this.handshakeClientSecret;
    }

    public void setHandshakeClientSecret(byte[] handshakeClientSecret) {
        this.handshakeClientSecret = handshakeClientSecret;
    }

    public byte[] getHandshakeServerSecret() {
        return this.handshakeServerSecret;
    }

    public void setHandshakeServerSecret(byte[] handshakeServerSecret) {
        this.handshakeServerSecret = handshakeServerSecret;
    }

    public byte[] getHandshakeClientKey() {
        return this.handshakeClientKey;
    }

    public void setHandshakeClientKey(byte[] handshakeClientKey) {
        this.handshakeClientKey = handshakeClientKey;
    }

    public byte[] getHandshakeServerKey() {
        return this.handshakeServerKey;
    }

    public void setHandshakeServerKey(byte[] handshakeServerKey) {
        this.handshakeServerKey = handshakeServerKey;
    }

    public byte[] getHandshakeClientIv() {
        return this.handshakeClientIv;
    }

    public void setHandshakeClientIv(byte[] handshakeClientIv) {
        this.handshakeClientIv = handshakeClientIv;
    }

    public byte[] getHandshakeServerIv() {
        return this.handshakeServerIv;
    }

    public void setHandshakeServerIv(byte[] handshakeServerIv) {
        this.handshakeServerIv = handshakeServerIv;
    }

    public byte[] getHandshakeClientHeaderProtectionKey() {
        return this.handshakeClientHeaderProtectionKey;
    }

    public void setHandshakeClientHeaderProtectionKey(byte[] handshakeClientHeaderProtectionKey) {
        this.handshakeClientHeaderProtectionKey = handshakeClientHeaderProtectionKey;
    }

    public byte[] getHandshakeServerHeaderProtectionKey() {
        return this.handshakeServerHeaderProtectionKey;
    }

    public void setHandshakeServerHeaderProtectionKey(byte[] handshakeServerHeaderProtectionKey) {
        this.handshakeServerHeaderProtectionKey = handshakeServerHeaderProtectionKey;
    }

    public boolean isApplicationSecretsInitialized() {
        return this.applicationSecretsInitialized;
    }

    public void setApplicationSecretsInitialized(boolean applicationSecretsInitialized) {
        this.applicationSecretsInitialized = applicationSecretsInitialized;
    }

    public byte[] getApplicationClientSecret() {
        return this.applicationClientSecret;
    }

    public void setApplicationClientSecret(byte[] applicationClientSecret) {
        this.applicationClientSecret = applicationClientSecret;
    }

    public byte[] getApplicationServerSecret() {
        return this.applicationServerSecret;
    }

    public void setApplicationServerSecret(byte[] applicationServerSecret) {
        this.applicationServerSecret = applicationServerSecret;
    }

    public byte[] getApplicationClientKey() {
        return this.applicationClientKey;
    }

    public void setApplicationClientKey(byte[] applicationClientKey) {
        this.applicationClientKey = applicationClientKey;
    }

    public byte[] getApplicationServerKey() {
        return this.applicationServerKey;
    }

    public void setApplicationServerKey(byte[] applicationServerKey) {
        this.applicationServerKey = applicationServerKey;
    }

    public byte[] getApplicationClientIv() {
        return this.applicationClientIv;
    }

    public void setApplicationClientIv(byte[] applicationClientIv) {
        this.applicationClientIv = applicationClientIv;
    }

    public byte[] getApplicationServerIv() {
        return this.applicationServerIv;
    }

    public void setApplicationServerIv(byte[] applicationServerIv) {
        this.applicationServerIv = applicationServerIv;
    }

    public byte[] getApplicationClientHeaderProtectionKey() {
        return this.applicationClientHeaderProtectionKey;
    }

    public void setApplicationClientHeaderProtectionKey(byte[] applicationClientHeaderProtectionKey) {
        this.applicationClientHeaderProtectionKey = applicationClientHeaderProtectionKey;
    }

    public byte[] getApplicationServerHeaderProtectionKey() {
        return this.applicationServerHeaderProtectionKey;
    }

    public void setApplicationServerHeaderProtectionKey(byte[] applicationServerHeaderProtectionKey) {
        this.applicationServerHeaderProtectionKey = applicationServerHeaderProtectionKey;
    }

    public boolean isZeroRTTSecretsInitialized() {
        return this.zeroRTTSecretsInitialized;
    }

    public void setZeroRTTSecretsInitialized(boolean zeroRTTSecretsInitialized) {
        this.zeroRTTSecretsInitialized = zeroRTTSecretsInitialized;
    }

    public byte[] getZeroRTTClientSecret() {
        return this.zeroRTTClientSecret;
    }

    public void setZeroRTTClientSecret(byte[] zeroRTTClientSecret) {
        this.zeroRTTClientSecret = zeroRTTClientSecret;
    }

    public byte[] getZeroRTTServerSecret() {
        return this.zeroRTTServerSecret;
    }

    public void setZeroRTTServerSecret(byte[] zeroRTTServerSecret) {
        this.zeroRTTServerSecret = zeroRTTServerSecret;
    }

    public byte[] getZeroRTTClientKey() {
        return this.zeroRTTClientKey;
    }

    public void setZeroRTTClientKey(byte[] zeroRTTClientKey) {
        this.zeroRTTClientKey = zeroRTTClientKey;
    }

    public byte[] getZeroRTTServerKey() {
        return this.zeroRTTServerKey;
    }

    public void setZeroRTTServerKey(byte[] zeroRTTServerKey) {
        this.zeroRTTServerKey = zeroRTTServerKey;
    }

    public byte[] getZeroRTTClientIv() {
        return this.zeroRTTClientIv;
    }

    public void setZeroRTTClientIv(byte[] zeroRTTClientIv) {
        this.zeroRTTClientIv = zeroRTTClientIv;
    }

    public byte[] getZeroRTTServerIv() {
        return this.zeroRTTServerIv;
    }

    public void setZeroRTTServerIv(byte[] zeroRTTServerIv) {
        this.zeroRTTServerIv = zeroRTTServerIv;
    }

    public byte[] getZeroRTTClientHeaderProtectionKey() {
        return this.zeroRTTClientHeaderProtectionKey;
    }

    public void setZeroRTTClientHeaderProtectionKey(byte[] zeroRTTClientHeaderProtectionKey) {
        this.zeroRTTClientHeaderProtectionKey = zeroRTTClientHeaderProtectionKey;
    }

    public byte[] getZeroRTTServerHeaderProtectionKey() {
        return this.zeroRTTServerHeaderProtectionKey;
    }

    public void setZeroRTTServerHeaderProtectionKey(byte[] zeroRTTServerHeaderProtectionKey) {
        this.zeroRTTServerHeaderProtectionKey = zeroRTTServerHeaderProtectionKey;
    }

    public HKDFAlgorithm getHkdfAlgorithm() {
        return this.hkdfAlgorithm;
    }

    public void setHkdfAlgorithm(HKDFAlgorithm hkdfAlgorithm) {
        this.hkdfAlgorithm = hkdfAlgorithm;
    }

    public Cipher getAeadCipher() {
        return this.aeadCipher;
    }

    public void setAeadCipher(Cipher aeadCipher) {
        this.aeadCipher = aeadCipher;
    }

    public Cipher getInitalHeaderProtectionCipher() {
        return this.initalHeaderProtectionCipher;
    }

    public void setInitalHeaderProtectionCipher(Cipher initalHeaderProtectionCipher) {
        this.initalHeaderProtectionCipher = initalHeaderProtectionCipher;
    }

    public Cipher getHeaderProtectionCipher() {
        return this.headerProtectionCipher;
    }

    public void setHeaderProtectionCipher(Cipher headerProtectionCipher) {
        this.headerProtectionCipher = headerProtectionCipher;
    }

    public List<byte[]> getSupportedVersions() {
        return this.supportedVersions;
    }

    public void setSupportedVersions(List<byte[]> supportedVersions) {
        this.supportedVersions = supportedVersions;
    }

    public void addSupportedVersions(List<byte[]> supportedVersions) {
        this.supportedVersions.addAll(supportedVersions);
    }

    public ConnectionCloseFrame getReceivedConnectionCloseFrame() {
        return this.receivedConnectionCloseFrame;
    }

    public void setReceivedConnectionCloseFrame(ConnectionCloseFrame receivedConnectionCloseFrame) {
        this.receivedConnectionCloseFrame = receivedConnectionCloseFrame;
    }

    public HKDFAlgorithm getZeroRTTHKDFAlgorithm() {
        return this.zeroRTTHKDFAlgorithm;
    }

    public void setZeroRTTHKDFAlgorithm(HKDFAlgorithm zeroRTTHKDFAlgorithm) {
        this.zeroRTTHKDFAlgorithm = zeroRTTHKDFAlgorithm;
    }

    public Cipher getZeroRTTAeadCipher() {
        return this.zeroRTTAeadCipher;
    }

    public void setZeroRTTAeadCipher(Cipher zeroRTTAeadCipher) {
        this.zeroRTTAeadCipher = zeroRTTAeadCipher;
    }

    public Cipher getZeroRTTHeaderProtectionCipher() {
        return this.zeroRTTHeaderProtectionCipher;
    }

    public void setZeroRTTHeaderProtectionCipher(Cipher zeroRTTHeaderProtectionCipher) {
        this.zeroRTTHeaderProtectionCipher = zeroRTTHeaderProtectionCipher;
    }

    public CipherSuite getZeroRTTCipherSuite() {
        return this.zeroRTTCipherSuite;
    }

    public void setZeroRTTCipherSuite(CipherSuite zeroRTTCipherSuite) {
        this.zeroRTTCipherSuite = zeroRTTCipherSuite;
    }

    public byte[] getPathChallengeData() {
        return this.pathChallengeData;
    }

    public void setPathChallengeData(byte[] pathChallengeData) {
        this.pathChallengeData = pathChallengeData;
    }
}

