/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.constants.ChooserType;
import de.rub.nds.tlsattacker.core.layer.LayerStack;
import de.rub.nds.tlsattacker.core.layer.LayerStackFactory;
import de.rub.nds.tlsattacker.core.layer.constant.StackConfiguration;
import de.rub.nds.tlsattacker.core.layer.context.HttpContext;
import de.rub.nds.tlsattacker.core.layer.context.TcpContext;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.core.workflow.chooser.ChooserFactory;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Context {
    private Chooser chooser;
    private Config config;
    private TransportHandler transportHandler;
    private TcpContext tcpContext;
    private HttpContext httpContext;
    private TlsContext tlsContext;
    private QuicContext quicContext;
    private LayerStack layerStack;
    private ConnectionEndType talkingConnectionEndType = ConnectionEndType.CLIENT;
    private AliasedConnection connection;
    private State state;

    public Context(State state, AliasedConnection connection) {
        this.state = state;
        this.config = state.getConfig();
        this.chooser = ChooserFactory.getChooser(ChooserType.DEFAULT, this, this.config);
        this.connection = connection;
        this.prepareWithLayers(this.config.getDefaultLayerConfiguration());
    }

    public State getState() {
        return this.state;
    }

    public TcpContext getTcpContext() {
        return this.tcpContext;
    }

    public void setTcpContext(TcpContext tcpContext) {
        this.tcpContext = tcpContext;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public TlsContext getTlsContext() {
        return this.tlsContext;
    }

    public void setRecordContext(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
    }

    public ConnectionEndType getTalkingConnectionEndType() {
        return this.talkingConnectionEndType;
    }

    public void setTalkingConnectionEndType(ConnectionEndType talkingConnectionEndType) {
        this.talkingConnectionEndType = talkingConnectionEndType;
    }

    public AliasedConnection getConnection() {
        return this.connection;
    }

    public void setConnection(AliasedConnection connection) {
        this.connection = connection;
    }

    public Chooser getChooser() {
        return this.chooser;
    }

    public void setChooser(Chooser chooser) {
        this.chooser = chooser;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public LayerStack getLayerStack() {
        return this.layerStack;
    }

    public void setLayerStack(LayerStack layerStack) {
        this.layerStack = layerStack;
    }

    public TransportHandler getTransportHandler() {
        return this.transportHandler;
    }

    public void setTransportHandler(TransportHandler transportHandler) {
        this.transportHandler = transportHandler;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        if (this.connection == null) {
            info.append("Context{ (no connection set) }");
        } else {
            info.append("Context{'").append(this.connection.getAlias()).append("'");
            if (this.connection.getLocalConnectionEndType() == ConnectionEndType.SERVER) {
                info.append(", listening on port ").append(this.connection.getPort());
            } else {
                info.append(", connected to ").append(this.connection.getHostname()).append(":").append(this.connection.getPort());
            }
            info.append("}");
        }
        return info.toString();
    }

    public void setTlsContext(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
    }

    public void prepareWithLayers(StackConfiguration type) {
        this.tlsContext = new TlsContext(this);
        this.httpContext = new HttpContext(this);
        this.tcpContext = new TcpContext(this);
        this.quicContext = new QuicContext(this);
        this.layerStack = LayerStackFactory.createLayerStack(type, this);
        this.setLayerStack(this.layerStack);
    }

    public QuicContext getQuicContext() {
        return this.quicContext;
    }

    public void setQuicContext(QuicContext quicContext) {
        this.quicContext = quicContext;
    }
}

