/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.socket;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class EncapsulatingInputStream
extends InputStream {
    private final State state;
    private ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);

    public EncapsulatingInputStream(State state) {
        this.state = state;
    }

    @Override
    public int read() throws IOException {
        if (this.available() == 0) {
            this.checkForNewData();
        }
        return this.inputStream.read();
    }

    private void checkForNewData() throws IOException {
        ReceiveAction action = new ReceiveAction(new ApplicationMessage());
        action.setConnectionAlias(this.state.getTlsContext().getConnection().getAlias());
        action.execute(this.state);
        List<ProtocolMessage> receivedMessages = action.getReceivedMessages();
        LinkedList<ApplicationMessage> receivedAppMessages = new LinkedList<ApplicationMessage>();
        for (ProtocolMessage message : receivedMessages) {
            if (!(message instanceof ApplicationMessage)) continue;
            receivedAppMessages.add((ApplicationMessage)message);
        }
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (ApplicationMessage message : receivedAppMessages) {
            stream.write((byte[])message.getData().getValue());
        }
        this.inputStream = new ByteArrayInputStream(stream.toByteArray());
    }

    @Override
    public int available() throws IOException {
        if (this.inputStream.available() == 0) {
            this.checkForNewData();
            return this.inputStream.available();
        }
        return this.inputStream.available();
    }
}

