/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.parser;

import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.record.Record;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordParser
extends Parser<Record> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ProtocolVersion version;
    private final TlsContext tlsContext;

    public RecordParser(InputStream stream, ProtocolVersion version, TlsContext tlsContext) {
        super(stream);
        this.version = version;
        this.tlsContext = tlsContext;
    }

    @Override
    public void parse(Record record) {
        LOGGER.debug("Parsing Record");
        boolean isContentType = this.parseContentType(record);
        if (!isContentType) {
            record.setProtocolVersion(ProtocolVersion.DTLS13.getValue());
            this.parseDtls13UnifiedHeader(record);
        } else {
            ProtocolMessageType protocolMessageType = ProtocolMessageType.getContentType((Byte)record.getContentType().getValue());
            if (protocolMessageType == null) {
                protocolMessageType = ProtocolMessageType.UNKNOWN;
            }
            record.setContentMessageType(protocolMessageType);
            this.parseVersion(record);
            if (this.version.isDTLS()) {
                this.parseEpoch(record);
                this.parseSequenceNumber(record);
                if (protocolMessageType == ProtocolMessageType.TLS12_CID) {
                    this.parseConnectionId(record);
                }
            }
            this.parseLength(record);
        }
        this.parseProtocolMessageBytes(record);
        record.setCompleteRecordBytes(this.getAlreadyParsed());
    }

    private void parseEpoch(Record record) {
        record.setEpoch(this.parseIntField(2));
        LOGGER.debug("Epoch: {}", record.getEpoch().getValue());
    }

    private void parseSequenceNumber(Record record) {
        record.setSequenceNumber(this.parseBigIntField(6));
        LOGGER.debug("SequenceNumber: {}", record.getSequenceNumber().getValue());
    }

    private void parseConnectionId(Record record) {
        int connectionIdLength = this.tlsContext.getRecordLayer().getDecryptor().getRecordCipher((Integer)record.getEpoch().getValue()).getState().getConnectionId().length;
        record.setConnectionId(this.parseByteArrayField(connectionIdLength));
        LOGGER.debug("ConnectionID: {}", record.getConnectionId().getValue());
    }

    private boolean parseContentType(Record record) {
        byte firstByte = this.parseByteField(1);
        if ((firstByte & 0xE0) == 32) {
            record.setUnifiedHeader(firstByte);
            LOGGER.debug("UnifiedHeader: 00{}", (Object)Integer.toBinaryString(firstByte));
            return false;
        }
        record.setContentType(firstByte);
        LOGGER.debug("ContentType: {}", record.getContentType().getValue());
        return true;
    }

    private void parseDtls13UnifiedHeader(Record record) {
        byte header = (Byte)record.getUnifiedHeader().getValue();
        int lowerEpoch = header & 3;
        record.setEpoch(lowerEpoch);
        if (record.isUnifiedHeaderCidPresent()) {
            this.parseConnectionId(record);
        }
        if (record.isUnifiedHeaderSqnLong()) {
            record.setEncryptedSequenceNumber(this.parseByteArrayField(2));
        } else {
            record.setEncryptedSequenceNumber(this.parseByteArrayField(1));
        }
        if (record.isUnifiedHeaderLengthPresent()) {
            this.parseLength(record);
        }
    }

    private void parseVersion(Record record) {
        record.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion: {}", record.getProtocolVersion().getValue());
    }

    private void parseLength(Record record) {
        record.setLength(this.parseIntField(2));
        LOGGER.debug("Length: {}", record.getLength().getValue());
    }

    private void parseProtocolMessageBytes(Record record) {
        if (record.getLength().getValue() != null) {
            record.setProtocolMessageBytes(this.parseByteArrayField((Integer)record.getLength().getValue()));
        } else {
            record.setProtocolMessageBytes(this.parseByteArrayField(this.getBytesLeft()));
        }
        LOGGER.debug("ProtocolMessageBytes: {}", record.getProtocolMessageBytes().getValue());
    }
}

