/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.crypto;

import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RecordCryptoUnit {
    private static final Logger LOGGER = LogManager.getLogger();
    protected ArrayList<RecordCipher> recordCipherList = new ArrayList();

    public RecordCryptoUnit(RecordCipher recordCipher) {
        this.recordCipherList.add(0, recordCipher);
    }

    public RecordCipher getRecordMostRecentCipher() {
        return this.recordCipherList.get(this.recordCipherList.size() - 1);
    }

    public RecordCipher getRecordCipherForEpochBits(int epochBits, Record record) {
        for (int i = this.recordCipherList.size() - 1; i >= 0; --i) {
            if (i % 4 != epochBits) continue;
            record.setEpoch(i);
            return this.recordCipherList.get(i);
        }
        LOGGER.warn("Got no RecordCipher for epoch bits: {}", (Object)epochBits);
        return null;
    }

    public boolean isEpochZero() {
        return this.recordCipherList.size() == 1;
    }

    public RecordCipher getRecordCipher(int epoch) {
        if (this.recordCipherList.size() > epoch && this.recordCipherList.get(epoch) != null) {
            return this.recordCipherList.get(epoch);
        }
        LOGGER.warn("Got no RecordCipher for epoch: {}. Using epoch 0 cipher", (Object)epoch);
        return this.recordCipherList.get(0);
    }

    public void addNewRecordCipher(RecordCipher recordCipher) {
        this.recordCipherList.add(recordCipher);
    }

    public void removeAllCiphers() {
        this.recordCipherList = new ArrayList();
    }

    public void removeCiphers(int toRemove) {
        while (toRemove > 0 && !this.recordCipherList.isEmpty()) {
            this.recordCipherList.remove(this.recordCipherList.size() - 1);
            --toRemove;
        }
        if (toRemove > 0) {
            LOGGER.warn("Could not remove as many ciphers as specified");
        }
    }
}

