/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.compressor;

import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.compressor.AlgorithmFactory;
import de.rub.nds.tlsattacker.core.record.compressor.Decompressor;
import de.rub.nds.tlsattacker.core.record.compressor.compression.CompressionAlgorithm;

public class RecordDecompressor
extends Decompressor<Record> {
    private CompressionAlgorithm algorithm;
    private ProtocolVersion version;

    public RecordDecompressor(TlsContext tlsContext) {
        this.version = tlsContext.getChooser().getSelectedProtocolVersion();
        if (this.version.is13()) {
            this.setMethod(CompressionMethod.NULL);
        } else {
            this.setMethod(tlsContext.getChooser().getSelectedCompressionMethod());
        }
    }

    @Override
    public void decompress(Record record) {
        byte[] compressedBytes = (byte[])record.getCleanProtocolMessageBytes().getValue();
        byte[] cleanBytes = this.algorithm.decompress(compressedBytes);
        record.setCleanProtocolMessageBytes(cleanBytes);
    }

    public void setMethod(CompressionMethod method) {
        AlgorithmFactory factory = new AlgorithmFactory();
        this.algorithm = factory.getAlgorithm(this.version, method);
    }
}

