/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.ConnectionCloseFrame;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionCloseFrameSerializer
extends QuicFrameSerializer<ConnectionCloseFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ConnectionCloseFrameSerializer(ConnectionCloseFrame frame) {
        super(frame);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        this.writeErrorCode();
        QuicFrameType frameType = QuicFrameType.getFrameType((Byte)((ConnectionCloseFrame)this.frame).getFrameType().getValue());
        if (frameType == QuicFrameType.CONNECTION_CLOSE_QUIC_FRAME) {
            this.writeTriggerFrameType();
        }
        this.writeReasonPhraseLength();
        this.writeReasonPhrase();
        return this.getAlreadySerialized();
    }

    private void writeErrorCode() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((ConnectionCloseFrame)this.frame).getErrorCode().getValue()));
        LOGGER.debug("Error Code: {}", ((ConnectionCloseFrame)this.frame).getErrorCode().getValue());
    }

    private void writeTriggerFrameType() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((ConnectionCloseFrame)this.frame).getTriggerFrameType().getValue()));
        LOGGER.debug("Frame Type: {}", ((ConnectionCloseFrame)this.frame).getTriggerFrameType().getValue());
    }

    private void writeReasonPhraseLength() {
        if (((ConnectionCloseFrame)this.frame).getReasonPhraseLength() != null && ((ConnectionCloseFrame)this.frame).getReasonPhraseLength().getValue() != null) {
            this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((ConnectionCloseFrame)this.frame).getReasonPhraseLength().getValue()));
            LOGGER.debug("Reason Phrase Length: {}", ((ConnectionCloseFrame)this.frame).getReasonPhraseLength().getValue());
        }
    }

    private void writeReasonPhrase() {
        if (((ConnectionCloseFrame)this.frame).getReasonPhrase() != null && ((ConnectionCloseFrame)this.frame).getReasonPhrase().getValue() != null) {
            this.appendBytes((byte[])((ConnectionCloseFrame)this.frame).getReasonPhrase().getValue());
            LOGGER.debug("Reason Phrase: {}", ((ConnectionCloseFrame)this.frame).getReasonPhrase().getValue());
        }
    }
}

