/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.packet;

import de.rub.nds.tlsattacker.core.quic.packet.InitialPacket;
import de.rub.nds.tlsattacker.core.quic.parser.packet.LongHeaderPacketParser;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitialPacketParser
extends LongHeaderPacketParser<InitialPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public InitialPacketParser(InputStream stream, QuicContext context) {
        super(stream, context);
    }

    @Override
    public void parse(InitialPacket packet) {
        this.parseDestinationConnectionIdLength(packet);
        this.parseDestinationConnectionId(packet);
        this.parseSourceConnectionIdLength(packet);
        this.parseSourceConnectionId(packet);
        this.parseTokenLength(packet);
        this.parseToken(packet);
        this.parsePacketLength(packet);
        this.parseProtectedPacketNumberAndPayload(packet);
    }

    protected void parseTokenLength(InitialPacket packet) {
        try {
            int before = this.getStream().available();
            int result = (int)this.parseVariableLengthInteger();
            int after = this.getStream().available();
            packet.setTokenLength(result);
            packet.setTokenLengthSize(before - after);
            packet.protectedHeaderHelper.write(this.quicBuffer.toByteArray());
            this.quicBuffer.reset();
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        LOGGER.debug("Token Length: {}", packet.getTokenLength().getValue());
    }

    protected void parseToken(InitialPacket packet) {
        byte[] tokenBytes = this.parseByteArrayField((Integer)packet.getTokenLength().getValue());
        packet.setToken(tokenBytes);
        packet.protectedHeaderHelper.write(tokenBytes);
        LOGGER.debug("Token: {}", packet.getToken().getValue());
    }
}

