/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.packet;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.quic.constants.QuicCryptoSecrets;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class QuicPacket
extends ModifiableVariableHolder
implements DataContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected QuicPacketType packetType;
    protected ModifiableByte protectedFlags;
    protected ModifiableByte unprotectedFlags;
    protected ModifiableByteArray destinationConnectionId;
    protected ModifiableByte destinationConnectionIdLength;
    protected ModifiableInteger packetLength;
    protected int packetLengthSize;
    protected ModifiableByteArray protectedPacketNumber;
    protected ModifiableByteArray unprotectedPacketNumber;
    protected ModifiableByteArray restoredPacketNumber;
    protected int plainPacketNumber;
    protected ModifiableInteger packetNumberLength;
    protected ModifiableByteArray protectedPacketNumberAndPayload;
    protected ModifiableByteArray unprotectedPayload;
    protected ModifiableByteArray protectedPayload;
    public ModifiableByteArray completeUnprotectedHeader;
    public SilentByteArrayOutputStream protectedHeaderHelper = new SilentByteArrayOutputStream();
    public SilentByteArrayOutputStream unprotectedHeaderHelper = new SilentByteArrayOutputStream();
    protected QuicCryptoSecrets packetSecret;
    public int offsetToPacketNumber;
    protected int padding;

    public QuicPacket() {
    }

    public QuicPacket(QuicPacketType packetType) {
        this.packetType = packetType;
        this.offsetToPacketNumber = 0;
        this.padding = 0;
    }

    public abstract void buildUnprotectedPacketHeader();

    public abstract void convertCompleteProtectedHeader();

    public abstract Handler<? extends QuicPacket> getHandler(Context var1);

    public abstract Serializer<? extends QuicPacket> getSerializer(Context var1);

    public abstract Preparator<? extends QuicPacket> getPreparator(Context var1);

    public abstract Parser<? extends QuicPacket> getParser(Context var1, InputStream var2);

    public byte[] encodePacketNumber(long packetnumber) {
        if (packetnumber <= 255L) {
            return new byte[]{(byte)packetnumber};
        }
        if (packetnumber <= 65535L) {
            return new byte[]{(byte)(packetnumber >> 8), (byte)(packetnumber & 0xFFL)};
        }
        if (packetnumber <= 0xFFFFFFL) {
            return new byte[]{(byte)(packetnumber >> 16), (byte)(packetnumber >> 8), (byte)(packetnumber & 0xFFL)};
        }
        if (packetnumber <= 0xFFFFFFFFL) {
            return new byte[]{(byte)(packetnumber >> 24), (byte)(packetnumber >> 16), (byte)(packetnumber >> 8), (byte)(packetnumber & 0xFFL)};
        }
        return new byte[]{0};
    }

    public long decodePacketNumber(long truncatedPacketnumber, long largestPacketnumber, int packetnumberNBits) {
        long expectedPacketnumber = largestPacketnumber + 1L;
        long packetnumberWin = 1L << packetnumberNBits;
        long packetnumberMask = packetnumberWin - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long candidatePacketnumber = expectedPacketnumber & packetnumberMask | truncatedPacketnumber;
        long packetnumberHwin = packetnumberWin / 2L;
        if (candidatePacketnumber <= expectedPacketnumber - packetnumberHwin && candidatePacketnumber < 0x40000000L - packetnumberWin) {
            return candidatePacketnumber + packetnumberWin;
        }
        if (candidatePacketnumber > expectedPacketnumber + packetnumberHwin && candidatePacketnumber >= packetnumberWin) {
            return candidatePacketnumber - packetnumberWin;
        }
        return candidatePacketnumber;
    }

    protected byte encodePacketNumberLength(byte flags, byte[] packetNumber) throws Exception {
        if (packetNumber.length <= 1) {
            return flags;
        }
        if (packetNumber.length <= 2) {
            return (byte)(flags | 1);
        }
        if (packetNumber.length <= 3) {
            return (byte)(flags | 2);
        }
        if (packetNumber.length <= 4) {
            return (byte)(flags | 3);
        }
        throw new Exception("Packetnumber > 4 Byte ist not supported yet");
    }

    public void updateFlagsWithEncodedPacketNumber() {
        try {
            this.setUnprotectedFlags(this.encodePacketNumberLength((Byte)this.unprotectedFlags.getValue(), (byte[])this.unprotectedPacketNumber.getValue()));
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public byte[] getHeaderProtectionSample() {
        byte[] sample = new byte[16];
        if (this.protectedPayload != null) {
            System.arraycopy(this.protectedPayload.getValue(), 4 - (Integer)this.packetNumberLength.getValue(), sample, 0, 16);
        } else {
            System.arraycopy(this.protectedPacketNumberAndPayload.getValue(), 4, sample, 0, 16);
        }
        return sample;
    }

    @Override
    public String toCompactString() {
        return this.packetType.getName();
    }

    public void setProtectedFlags(byte protectedFlags) {
        this.protectedFlags = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.protectedFlags, (Byte)protectedFlags);
    }

    public void setProtectedFlags(ModifiableByte protectedFlags) {
        this.protectedFlags = protectedFlags;
    }

    public void setUnprotectedFlags(byte unprotectedFlags) {
        this.unprotectedFlags = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.unprotectedFlags, (Byte)unprotectedFlags);
    }

    public void setUnprotectedFlags(ModifiableByte unprotectedFlags) {
        this.unprotectedFlags = unprotectedFlags;
    }

    public void setPacketNumberLength(int packetNumberLength) {
        this.packetNumberLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.packetNumberLength, (Integer)packetNumberLength);
    }

    public void setPacketNumberLength(ModifiableInteger packetNumberLength) {
        this.packetNumberLength = packetNumberLength;
    }

    public void setProtectedPacketNumber(byte[] packetNumber) {
        this.protectedPacketNumber = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protectedPacketNumber, (byte[])packetNumber);
    }

    public void setProtectedPacketNumber(ModifiableByteArray packetNumber) {
        this.protectedPacketNumber = packetNumber;
    }

    public void setPacketLengthSize(int packetLengthSize) {
        this.packetLengthSize = packetLengthSize;
    }

    public void setUnprotectedPacketNumber(byte[] packetNumber) {
        this.setPacketNumberLength(packetNumber.length);
        this.unprotectedPacketNumber = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.unprotectedPacketNumber, (byte[])packetNumber);
    }

    public void setUnprotectedPacketNumber(ModifiableByteArray packetNumber) {
        this.setPacketNumberLength(((byte[])packetNumber.getValue()).length);
        this.unprotectedPacketNumber = packetNumber;
    }

    public void setUnprotectedPacketNumber(int packetNumber) {
        this.setUnprotectedPacketNumber(this.encodePacketNumber(packetNumber));
    }

    public void setRestoredPacketNumber(byte[] packetNumber) {
        this.restoredPacketNumber = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.restoredPacketNumber, (byte[])packetNumber);
    }

    public void setRestoredPacketNumber(ModifiableByteArray packetNumber) {
        this.restoredPacketNumber = packetNumber;
    }

    public void setRestoredPacketNumber(int packetNumber) {
        this.setRestoredPacketNumber(this.encodePacketNumber(packetNumber));
    }

    public void setPacketLength(int packetLength) {
        this.packetLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.packetLength, (Integer)packetLength);
    }

    public void setRestoredPacketNumber(ModifiableInteger packetLength) {
        this.packetLength = packetLength;
    }

    public void setDestinationConnectionId(byte[] destinationConnectionId) {
        this.destinationConnectionId = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.destinationConnectionId, (byte[])destinationConnectionId);
    }

    public void setDestinationConnectionId(ModifiableByteArray destinationConnectionId) {
        this.destinationConnectionId = destinationConnectionId;
    }

    public void setDestinationConnectionIdLength(byte destinationConnectionIdLength) {
        this.destinationConnectionIdLength = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.destinationConnectionIdLength, (Byte)destinationConnectionIdLength);
    }

    public void setDestinationConnectionIdLength(ModifiableByte destinationConnectionIdLength) {
        this.destinationConnectionIdLength = destinationConnectionIdLength;
    }

    public void setProtectedPacketNumberAndPayload(byte[] protectedPacketNumberAndPayload) {
        this.protectedPacketNumberAndPayload = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protectedPacketNumberAndPayload, (byte[])protectedPacketNumberAndPayload);
    }

    public void setProtectedPacketNumberAndPayload(ModifiableByteArray protectedPacketNumberAndPayload) {
        this.protectedPacketNumberAndPayload = protectedPacketNumberAndPayload;
    }

    public void setUnprotectedPayload(byte[] unprotectedPayload) {
        this.unprotectedPayload = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.unprotectedPayload, (byte[])unprotectedPayload);
    }

    public void setUnprotectedPayload(ModifiableByteArray unprotectedPayload) {
        this.unprotectedPayload = unprotectedPayload;
    }

    public void setProtectedPayload(byte[] protectedPayload) {
        this.protectedPayload = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protectedPayload, (byte[])protectedPayload);
    }

    public void setProtectedPayload(ModifiableByteArray protectedPayload) {
        this.protectedPayload = protectedPayload;
    }

    public void setPacketSecret(QuicCryptoSecrets packetSecret) {
        this.packetSecret = packetSecret;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setPlainPacketNumber(int plainPacketNumber) {
        this.plainPacketNumber = plainPacketNumber;
    }

    public ModifiableByte getProtectedFlags() {
        return this.protectedFlags;
    }

    public QuicPacketType getPacketType() {
        return this.packetType;
    }

    public ModifiableByte getUnprotectedFlags() {
        return this.unprotectedFlags;
    }

    public ModifiableByteArray getUnprotectedPacketNumber() {
        return this.unprotectedPacketNumber;
    }

    public ModifiableInteger getPacketNumberLength() {
        return this.packetNumberLength;
    }

    public ModifiableByteArray getProtectedPacketNumber() {
        return this.protectedPacketNumber;
    }

    public ModifiableByteArray getRestoredPacketNumber() {
        return this.restoredPacketNumber;
    }

    public int getPacketLengthSize() {
        return this.packetLengthSize;
    }

    public ModifiableInteger getPacketLength() {
        return this.packetLength;
    }

    public ModifiableByteArray getDestinationConnectionId() {
        return this.destinationConnectionId;
    }

    public ModifiableByte getDestinationConnectionIdLength() {
        return this.destinationConnectionIdLength;
    }

    public ModifiableByteArray getProtectedPacketNumberAndPayload() {
        return this.protectedPacketNumberAndPayload;
    }

    public ModifiableByteArray getUnprotectedPayload() {
        return this.unprotectedPayload;
    }

    public ModifiableByteArray getProtectedPayload() {
        return this.protectedPayload;
    }

    public int getPlainPacketNumber() {
        return this.plainPacketNumber;
    }

    public int getPadding() {
        return this.padding;
    }
}

