/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.packet;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.quic.constants.QuicCryptoSecrets;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.handler.packet.InitialPacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.LongHeaderPacket;
import de.rub.nds.tlsattacker.core.quic.parser.packet.InitialPacketParser;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.InitialPacketPreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.packet.InitialPacketSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
public class InitialPacket
extends LongHeaderPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty
    protected ModifiableInteger tokenLength;
    @ModifiableVariableProperty
    protected ModifiableByteArray token;
    public int tokenLengthSize;

    public InitialPacket() {
        super(QuicPacketType.INITIAL_PACKET);
        this.packetSecret = QuicCryptoSecrets.INITIAL_SECRET;
    }

    public InitialPacket(byte[] unprotectedPayload) {
        super(QuicPacketType.INITIAL_PACKET);
        this.packetSecret = QuicCryptoSecrets.INITIAL_SECRET;
        this.setUnprotectedPayload(unprotectedPayload);
    }

    public InitialPacket(byte flags, byte[] versionBytes) {
        super(QuicPacketType.INITIAL_PACKET);
        this.setProtectedFlags(flags);
        this.protectedHeaderHelper.write((int)flags);
        this.packetSecret = QuicCryptoSecrets.INITIAL_SECRET;
        this.setQuicVersion(versionBytes);
        this.protectedHeaderHelper.write(versionBytes);
    }

    @Override
    public void buildUnprotectedPacketHeader() {
        this.unprotectedHeaderHelper.write((int)((Byte)this.unprotectedFlags.getValue()).byteValue());
        ++this.offsetToPacketNumber;
        this.unprotectedHeaderHelper.write((byte[])this.quicVersion.getValue());
        this.offsetToPacketNumber += ((byte[])this.quicVersion.getValue()).length;
        this.unprotectedHeaderHelper.write((int)((byte)((byte[])this.destinationConnectionId.getValue()).length));
        ++this.offsetToPacketNumber;
        this.unprotectedHeaderHelper.write((byte[])this.destinationConnectionId.getValue());
        this.offsetToPacketNumber += ((Byte)this.destinationConnectionIdLength.getValue()).byteValue();
        this.unprotectedHeaderHelper.write((int)((byte)((byte[])this.sourceConnectionId.getValue()).length));
        ++this.offsetToPacketNumber;
        this.unprotectedHeaderHelper.write((byte[])this.sourceConnectionId.getValue());
        this.offsetToPacketNumber += ((Byte)this.sourceConnectionIdLength.getValue()).byteValue();
        byte[] tokenLengthBytes = VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)this.tokenLength.getValue()).intValue());
        this.unprotectedHeaderHelper.write(tokenLengthBytes);
        this.offsetToPacketNumber += tokenLengthBytes.length;
        if ((Integer)this.tokenLength.getValue() > 0) {
            this.unprotectedHeaderHelper.write((byte[])this.token.getValue());
            this.offsetToPacketNumber += ((byte[])this.token.getValue()).length;
        }
        byte[] packetLengthBytes = VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)this.packetLength.getValue()).intValue());
        this.unprotectedHeaderHelper.write(packetLengthBytes);
        this.offsetToPacketNumber += packetLengthBytes.length;
        this.unprotectedHeaderHelper.writeBytes((byte[])this.getUnprotectedPacketNumber().getValue());
        this.offsetToPacketNumber += ((byte[])this.getUnprotectedPacketNumber().getValue()).length;
        this.completeUnprotectedHeader = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.completeUnprotectedHeader, (byte[])this.unprotectedHeaderHelper.toByteArray());
    }

    @Override
    public void convertCompleteProtectedHeader() {
        byte[] r = this.protectedHeaderHelper.toByteArray();
        r[0] = (Byte)this.unprotectedFlags.getValue();
        this.offsetToPacketNumber = 6 + ((byte[])this.destinationConnectionId.getValue()).length + 1 + ((byte[])this.sourceConnectionId.getValue()).length + this.tokenLengthSize + ((byte[])this.token.getValue()).length + this.packetLengthSize;
        this.completeUnprotectedHeader = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.completeUnprotectedHeader, (byte[])r);
    }

    public InitialPacketHandler getHandler(Context context) {
        return new InitialPacketHandler(context.getQuicContext());
    }

    public InitialPacketSerializer getSerializer(Context context) {
        return new InitialPacketSerializer(this);
    }

    public InitialPacketPreparator getPreparator(Context context) {
        return new InitialPacketPreparator(context.getChooser(), this);
    }

    public InitialPacketParser getParser(Context context, InputStream stream) {
        return new InitialPacketParser(stream, context.getQuicContext());
    }

    public void setToken(ModifiableByteArray token) {
        this.token = token;
    }

    public void setToken(byte[] array) {
        this.token = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.token, (byte[])array);
    }

    public void setTokenLength(ModifiableInteger tokenLength) {
        this.tokenLength = tokenLength;
        this.tokenLengthSize = VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)tokenLength.getValue()).intValue()).length;
    }

    public void setTokenLength(int length) {
        this.tokenLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.tokenLength, (Integer)length);
        this.tokenLengthSize = VariableLengthIntegerEncoding.encodeVariableLengthInteger(length).length;
    }

    public void setTokenLengthSize(int size) {
        this.tokenLengthSize = size;
    }

    public ModifiableByteArray getToken() {
        return this.token;
    }

    public ModifiableInteger getTokenLength() {
        return this.tokenLength;
    }

    public int getTokenLengthSize() {
        return this.tokenLengthSize;
    }
}

