/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.handler.packet;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.quic.handler.packet.LongHeaderPacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.InitialPacket;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacketCryptoComputations;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitialPacketHandler
extends LongHeaderPacketHandler<InitialPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public InitialPacketHandler(QuicContext quicContext) {
        super(quicContext);
    }

    @Override
    public void adjustContext(InitialPacket packet) {
        this.quicContext.setDestinationConnectionId((byte[])packet.getSourceConnectionId().getValue());
        try {
            if (!this.quicContext.isInitialSecretsInitialized()) {
                QuicPacketCryptoComputations.calculateInitialSecrets(this.quicContext);
            }
        }
        catch (CryptoException | NoSuchAlgorithmException e) {
            LOGGER.error("Could not calculate initial secrets", e);
        }
    }
}

