/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.constants;

import de.rub.nds.tlsattacker.core.quic.constants.QuicVersion;
import java.util.HashMap;
import java.util.Map;

public enum QuicPacketType {
    UNKNOWN(255, 255),
    INITIAL_PACKET(192, 208),
    ZERO_RTT_PACKET(208, 224),
    HANDSHAKE_PACKET(224, 240),
    RETRY_PACKET(240, 192),
    ONE_RTT_PACKET(128, 128),
    VERSION_NEGOTIATION(32, 32);

    private static final Map<Byte, QuicPacketType> QUIC1_MAP;
    private static final Map<Byte, QuicPacketType> QUIC2_MAP;
    private final byte headerQuic1;
    private final byte headerQuic2;

    private QuicPacketType(int headerQuic1, int headerQuic2) {
        this.headerQuic1 = (byte)headerQuic1;
        this.headerQuic2 = (byte)headerQuic2;
    }

    public static QuicPacketType getPacketTypeFromFirstByte(QuicVersion version, int firstByte) {
        if (QuicPacketType.isShortHeaderPacket(firstByte)) {
            return ONE_RTT_PACKET;
        }
        QuicPacketType type = QuicPacketType.getHeaderMap(version).get((byte)(firstByte & 0xF0));
        if (type != null) {
            return type;
        }
        return UNKNOWN;
    }

    public static boolean isLongHeaderPacket(int firstByte) {
        return !QuicPacketType.isShortHeaderPacket(firstByte);
    }

    public static boolean isShortHeaderPacket(int firstByte) {
        return (firstByte & 0x80) == 0;
    }

    public byte getHeader(QuicVersion version) {
        switch (version) {
            case VERSION_1: {
                return this.headerQuic1;
            }
            case VERSION_2: {
                return this.headerQuic2;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Map<Byte, QuicPacketType> getHeaderMap(QuicVersion version) {
        switch (version) {
            case VERSION_1: {
                return QUIC1_MAP;
            }
            case VERSION_2: {
                return QUIC2_MAP;
            }
        }
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name();
    }

    static {
        QUIC1_MAP = new HashMap<Byte, QuicPacketType>();
        QUIC2_MAP = new HashMap<Byte, QuicPacketType>();
        for (QuicPacketType type : QuicPacketType.values()) {
            if (type == UNKNOWN) continue;
            QUIC1_MAP.put(type.headerQuic1, type);
            QUIC2_MAP.put(type.headerQuic2, type);
        }
    }
}

