/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.EllipticCurvesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurvesExtensionSerializer
extends ExtensionSerializer<EllipticCurvesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EllipticCurvesExtensionMessage msg;

    public EllipticCurvesExtensionSerializer(EllipticCurvesExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing EllipticCurvesExtensionMessage");
        this.writeSupportedGroupsLength(this.msg);
        this.writeSupportedGroups(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSupportedGroupsLength(EllipticCurvesExtensionMessage msg) {
        this.appendInt((Integer)msg.getSupportedGroupsLength().getValue(), 2);
        LOGGER.debug("SupportedGroupsLength: {}", msg.getSupportedGroupsLength().getValue());
    }

    private void writeSupportedGroups(EllipticCurvesExtensionMessage msg) {
        this.appendBytes((byte[])msg.getSupportedGroups().getValue());
        LOGGER.debug("SupportedGroups: {}", msg.getSupportedGroups().getValue());
    }
}

