/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2MessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ClientHelloSerializer
extends SSL2MessageSerializer<SSL2ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ClientHelloSerializer(SSL2ClientHelloMessage message) {
        super(message);
    }

    @Override
    public byte[] serializeMessageContent() {
        LOGGER.debug("Serializing SSL2ClientHello");
        this.writeProtocolVersion();
        this.writeCipherSuiteLength();
        this.writeSessionIDLength();
        this.writeChallengeLength();
        this.writeCipherSuites();
        this.writeSessionID();
        this.writeChallenge();
        return this.getAlreadySerialized();
    }

    private void writeProtocolVersion() {
        this.appendBytes((byte[])((SSL2ClientHelloMessage)this.message).getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: {}", ((SSL2ClientHelloMessage)this.message).getProtocolVersion().getValue());
    }

    private void writeCipherSuiteLength() {
        this.appendInt((Integer)((SSL2ClientHelloMessage)this.message).getCipherSuiteLength().getValue(), 2);
        LOGGER.debug("CipherSuiteLength: {}", ((SSL2ClientHelloMessage)this.message).getCipherSuiteLength().getValue());
    }

    private void writeSessionIDLength() {
        this.appendInt((Integer)((SSL2ClientHelloMessage)this.message).getSessionIdLength().getValue(), 2);
        LOGGER.debug("SessionIDLength: {}", ((SSL2ClientHelloMessage)this.message).getSessionIdLength().getValue());
    }

    private void writeChallengeLength() {
        this.appendInt((Integer)((SSL2ClientHelloMessage)this.message).getChallengeLength().getValue(), 2);
        LOGGER.debug("ChallengeLength: {}", ((SSL2ClientHelloMessage)this.message).getChallengeLength().getValue());
    }

    private void writeCipherSuites() {
        this.appendBytes((byte[])((SSL2ClientHelloMessage)this.message).getCipherSuites().getValue());
        LOGGER.debug("CipherSuites: {}", ((SSL2ClientHelloMessage)this.message).getCipherSuites().getValue());
    }

    private void writeSessionID() {
        this.appendBytes((byte[])((SSL2ClientHelloMessage)this.message).getSessionId().getValue());
        LOGGER.debug("SessionID: {}", ((SSL2ClientHelloMessage)this.message).getSessionId().getValue());
    }

    private void writeChallenge() {
        this.appendBytes((byte[])((SSL2ClientHelloMessage)this.message).getChallenge().getValue());
        LOGGER.debug("Challenge: {}", ((SSL2ClientHelloMessage)this.message).getChallenge().getValue());
    }
}

