/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.NewConnectionIdMessage;
import de.rub.nds.tlsattacker.core.protocol.message.connectionid.ConnectionId;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewConnectionIdSerializer
extends HandshakeMessageSerializer<NewConnectionIdMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NewConnectionIdSerializer(NewConnectionIdMessage message) {
        super(message);
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing NewConnectionIdMessage");
        this.serializeConnectionIdsLength();
        this.serializeConnectionIds();
        this.serializeUsage();
        return this.getAlreadySerialized();
    }

    private void serializeUsage() {
        this.appendByte(((NewConnectionIdMessage)this.message).getUsage().getValue());
        LOGGER.debug("Usage: {}", (Object)((NewConnectionIdMessage)this.message).getUsage().getValue());
    }

    private void serializeConnectionIds() {
        LOGGER.debug("ConnectionIds: ");
        for (ConnectionId connectionId : ((NewConnectionIdMessage)this.message).getConnectionIds()) {
            this.appendInt((Integer)connectionId.getLength().getValue(), 1);
            this.appendBytes((byte[])connectionId.getConnectionId().getValue());
            LOGGER.debug("\t - {}", connectionId.getConnectionId().getValue());
        }
    }

    private void serializeConnectionIdsLength() {
        this.appendInt((Integer)((NewConnectionIdMessage)this.message).getConnectionIdsLength().getValue(), 2);
        LOGGER.debug("ConnectionIdsLength: {}", (Object)((NewConnectionIdMessage)this.message).getConnectionIdsLength());
    }
}

