/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelloVerifyRequestSerializer
extends HandshakeMessageSerializer<HelloVerifyRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HelloVerifyRequestMessage msg;

    public HelloVerifyRequestSerializer(HelloVerifyRequestMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing HelloVerifyRequestMessage");
        this.writeProtocolVersion(this.msg);
        this.writeCookieLength(this.msg);
        this.writeCookie(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeProtocolVersion(HelloVerifyRequestMessage msg) {
        this.appendBytes((byte[])msg.getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: {}", msg.getProtocolVersion().getValue());
    }

    private void writeCookieLength(HelloVerifyRequestMessage msg) {
        this.appendByte((Byte)msg.getCookieLength().getValue());
        LOGGER.debug("CookieLength: {}", msg.getCookieLength().getValue());
    }

    private void writeCookie(HelloVerifyRequestMessage msg) {
        this.appendBytes((byte[])msg.getCookie().getValue());
        LOGGER.debug("Cookie: {}", msg.getCookie().getValue());
    }
}

