/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.CertificateStatusMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateStatusSerializer
extends HandshakeMessageSerializer<CertificateStatusMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateStatusMessage msg;

    public CertificateStatusSerializer(CertificateStatusMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing CertificateStatusMessage");
        this.writeCertificateStatusType(this.msg);
        this.writeOcspResponseLength(this.msg);
        this.writeOcspResponse(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeCertificateStatusType(CertificateStatusMessage msg) {
        this.appendInt((Integer)msg.getCertificateStatusType().getValue(), 1);
        LOGGER.debug("CertificateStatusType: {}", msg.getCertificateStatusType().getValue());
    }

    private void writeOcspResponseLength(CertificateStatusMessage msg) {
        this.appendInt((Integer)msg.getOcspResponseLength().getValue(), 3);
        LOGGER.debug("OCSP Response Length: {}", msg.getOcspResponseLength().getValue());
    }

    private void writeOcspResponse(CertificateStatusMessage msg) {
        this.appendBytes((byte[])msg.getOcspResponseBytes().getValue());
        LOGGER.debug("OCSP Response: {}", msg.getOcspResponseBytes().getValue());
    }
}

