/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateMessageSerializer
extends HandshakeMessageSerializer<CertificateMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateMessage msg;
    private final ProtocolVersion version;

    public CertificateMessageSerializer(CertificateMessage message, ProtocolVersion version) {
        super(message);
        this.msg = message;
        this.version = version;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing CertificateMessage");
        if (this.version.is13()) {
            this.writeRequestContextLength(this.msg);
            this.writeRequestContext(this.msg);
        }
        this.writeCertificatesListLength(this.msg);
        this.writeCertificatesListBytes(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeRequestContextLength(CertificateMessage msg) {
        this.appendInt((Integer)msg.getRequestContextLength().getValue(), 1);
        LOGGER.debug("RequestContextLength: {}", msg.getRequestContextLength().getValue());
    }

    private void writeRequestContext(CertificateMessage msg) {
        this.appendBytes((byte[])msg.getRequestContext().getValue());
        LOGGER.debug("RequestContext: {}", msg.getRequestContext().getValue());
    }

    private void writeCertificatesListLength(CertificateMessage msg) {
        this.appendInt((Integer)msg.getCertificatesListLength().getValue(), 3);
        LOGGER.debug("certificatesListLength: {}", msg.getCertificatesListLength().getValue());
    }

    private void writeCertificatesListBytes(CertificateMessage msg) {
        this.appendBytes((byte[])msg.getCertificatesListBytes().getValue());
        LOGGER.debug("certificatesListBytes: {}", msg.getCertificatesListBytes().getValue());
    }
}

