/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.selection;

import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureAndHashAlgorithmSelector {
    private static final Logger LOGGER = LogManager.getLogger();

    public static SignatureAndHashAlgorithm selectSignatureAndHashAlgorithm(Chooser chooser, boolean restrictToTls13MessageSigningAlgorithms) {
        SignatureAndHashAlgorithm signHashAlgo;
        if (chooser.getConfig().getAutoAdjustSignatureAndHashAlgorithm().booleanValue()) {
            List<SignatureAndHashAlgorithm> ourSupported;
            List<SignatureAndHashAlgorithm> peerSupported;
            X509PublicKeyType publicKeyType = chooser.getTalkingConnectionEnd() == ConnectionEndType.SERVER ? chooser.getContext().getTlsContext().getServerX509Context().getChooser().getSubjectPublicKeyType() : chooser.getContext().getTlsContext().getClientX509Context().getChooser().getSubjectPublicKeyType();
            LOGGER.debug("Selecting SignatureAndHashAlgorithm for public key type {}", (Object)publicKeyType);
            List<Object> candidateList = new LinkedList<SignatureAndHashAlgorithm>();
            if (chooser.getTalkingConnectionEnd() == ConnectionEndType.SERVER) {
                peerSupported = chooser.getClientSupportedSignatureAndHashAlgorithms();
                ourSupported = chooser.getServerSupportedSignatureAndHashAlgorithms();
            } else {
                peerSupported = chooser.getServerSupportedSignatureAndHashAlgorithms();
                ourSupported = chooser.getClientSupportedSignatureAndHashAlgorithms();
            }
            ourSupported = ourSupported.stream().filter(algo -> algo.suitableForSignatureKeyType(publicKeyType)).collect(Collectors.toList());
            candidateList.addAll(ourSupported);
            candidateList.retainAll(peerSupported);
            if (restrictToTls13MessageSigningAlgorithms) {
                candidateList = candidateList.stream().filter(SignatureAndHashAlgorithm::suitedForSigningTls13Messages).collect(Collectors.toList());
            }
            LOGGER.debug("Algorithm pairs supported by both peers, suitable for public key type, and protocol version: [{}]", (Object)candidateList.stream().map(Enum::name).collect(Collectors.joining(",")));
            if (candidateList.isEmpty()) {
                signHashAlgo = SignatureAndHashAlgorithmSelector.selectFallBackAlgorithm(chooser, ourSupported, publicKeyType);
                LOGGER.debug("No common algorithm found, selected fall-back algorithm {}", (Object)signHashAlgo);
            } else {
                signHashAlgo = (SignatureAndHashAlgorithm)((Object)candidateList.get(0));
            }
        } else {
            signHashAlgo = chooser.getConfig().getDefaultSelectedSignatureAndHashAlgorithm();
            LOGGER.debug("Using pre-configured algorithm pair {}", (Object)signHashAlgo);
        }
        return signHashAlgo;
    }

    private static SignatureAndHashAlgorithm selectFallBackAlgorithm(Chooser chooser, List<SignatureAndHashAlgorithm> ourSuitableSupported, X509PublicKeyType publicKeyType) {
        if (chooser.getSelectedSigHashAlgorithm().suitableForSignatureKeyType(publicKeyType)) {
            return chooser.getSelectedSigHashAlgorithm();
        }
        if (!ourSuitableSupported.isEmpty()) {
            return ourSuitableSupported.get(0);
        }
        return chooser.getSelectedSigHashAlgorithm();
    }
}

