/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.message.extension.AlpnExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.alpn.AlpnEntry;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.alpn.AlpnEntryPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.alpn.AlpnEntrySerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlpnExtensionPreparator
extends ExtensionPreparator<AlpnExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AlpnExtensionMessage msg;

    public AlpnExtensionPreparator(Chooser chooser, AlpnExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LinkedList<AlpnEntry> alpnEntryList = new LinkedList<AlpnEntry>();
        if (this.chooser.getTalkingConnectionEnd() == ConnectionEndType.CLIENT) {
            List<String> alpnStringList = this.chooser.getConfig().getDefaultProposedAlpnProtocols();
            for (String alpnProtocol : alpnStringList) {
                alpnEntryList.add(new AlpnEntry(alpnProtocol));
            }
        } else if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            alpnEntryList.add(new AlpnEntry(this.chooser.getConfig().getDefaultSelectedAlpnProtocol()));
            LOGGER.debug("Enforce settings is active: Selected ALPN protocol is {}", (Object)this.chooser.getConfig().getDefaultSelectedAlpnProtocol());
        } else {
            List<String> proposedAlpnProtocols = this.chooser.getProposedAlpnProtocols();
            if (proposedAlpnProtocols.contains(this.chooser.getConfig().getDefaultSelectedAlpnProtocol())) {
                alpnEntryList.add(new AlpnEntry(this.chooser.getConfig().getDefaultSelectedAlpnProtocol()));
                LOGGER.debug("ALPN selected protocol: {}", (Object)this.chooser.getConfig().getDefaultSelectedAlpnProtocol());
            } else if (this.chooser.getProposedAlpnProtocols().size() > 0) {
                alpnEntryList.add(new AlpnEntry(this.chooser.getProposedAlpnProtocols().get(0)));
                LOGGER.debug("Default ALPN selected protocol is not supported by peer. Respecting client protocols.");
                LOGGER.debug("ALPN selected protocol: {}", (Object)this.chooser.getProposedAlpnProtocols().get(0));
            } else {
                alpnEntryList.add(new AlpnEntry(this.chooser.getConfig().getDefaultSelectedAlpnProtocol()));
                LOGGER.debug("Cannot choose protocol the client supported. Enforcing server choice");
            }
        }
        this.msg.setAlpnEntryList(alpnEntryList);
        this.setEntryListBytes(alpnEntryList);
        LOGGER.debug("Prepared the ALPN Extension with announced protocols {}", (Object)this.msg.getProposedAlpnProtocols());
        this.msg.setProposedAlpnProtocolsLength(((byte[])this.msg.getProposedAlpnProtocols().getValue()).length);
        LOGGER.debug("Prepared the ALPN Extension with announced protocols length {}", this.msg.getProposedAlpnProtocolsLength().getValue());
    }

    private void setEntryListBytes(List<AlpnEntry> alpnEntryList) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (AlpnEntry entry : alpnEntryList) {
            AlpnEntryPreparator preparator = new AlpnEntryPreparator(this.chooser, entry);
            preparator.prepare();
            AlpnEntrySerializer serializer = new AlpnEntrySerializer(entry);
            stream.write(serializer.serialize());
        }
        this.msg.setProposedAlpnProtocols(stream.toByteArray());
    }
}

