/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.protocol.crypto.hash.HashCalculator;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.selection.SignatureAndHashAlgorithmSelector;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class SrpServerKeyExchangePreparator
extends ServerKeyExchangePreparator<SrpServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private BigInteger publicKey;
    private SignatureAndHashAlgorithm selectedSignatureHashAlgo;
    private byte[] signature;
    private final SrpServerKeyExchangeMessage msg;

    public SrpServerKeyExchangePreparator(Chooser chooser, SrpServerKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.prepareKeyExchangeComputations();
        this.setComputedModulus(this.msg);
        this.setComputedGenerator(this.msg);
        this.setComputedSalt(this.msg);
        this.setComputedPrivateKey(this.msg);
        this.setSRPIdentity(this.msg);
        this.setSRPPassword(this.msg);
        BigInteger modulus = (BigInteger)this.msg.getKeyExchangeComputations().getModulus().getValue();
        BigInteger generator = (BigInteger)this.msg.getKeyExchangeComputations().getGenerator().getValue();
        BigInteger privateKey = (BigInteger)this.msg.getKeyExchangeComputations().getPrivateKey().getValue();
        byte[] identity = (byte[])this.msg.getKeyExchangeComputations().getSRPIdentity().getValue();
        byte[] password = (byte[])this.msg.getKeyExchangeComputations().getSRPPassword().getValue();
        byte[] salt = (byte[])this.msg.getKeyExchangeComputations().getSalt().getValue();
        this.publicKey = this.generatePublicKey(modulus, generator, privateKey, identity, password, salt);
        this.publicKey.mod(modulus);
        this.prepareModulus(this.msg);
        this.prepareModulusLength(this.msg);
        this.prepareGenerator(this.msg);
        this.prepareGeneratorLength(this.msg);
        this.prepareSalt(this.msg);
        this.prepareSaltLength(this.msg);
        this.preparePublicKey(this.msg);
        this.preparePublicKeyLength(this.msg);
        this.selectedSignatureHashAlgo = SignatureAndHashAlgorithmSelector.selectSignatureAndHashAlgorithm(this.chooser, false);
        this.prepareSignatureAndHashAlgorithm(this.msg);
        this.prepareClientServerRandom(this.msg);
        this.signature = this.generateSignature(this.selectedSignatureHashAlgo, this.generateToBeSigned());
        this.prepareSignature(this.msg);
        this.prepareSignatureLength(this.msg);
    }

    private BigInteger generatePublicKey(BigInteger modulus, BigInteger generator, BigInteger privateKey, byte[] identity, byte[] password, byte[] salt) {
        BigInteger k = this.calculateSRP6Multiplier(modulus, generator);
        BigInteger x = this.calculateX(salt, identity, password);
        if (modulus.compareTo(BigInteger.ZERO) < 0) {
            LOGGER.warn("Modulus is zero or negative. Using publicKey=0.");
            return BigInteger.ZERO;
        }
        BigInteger v = generator.modPow(x, modulus);
        BigInteger helpValue1 = k.multiply(v);
        BigInteger helpValue2 = helpValue1.mod(modulus);
        helpValue1 = generator.modPow(privateKey, modulus);
        BigInteger helpValue3 = helpValue1.add(helpValue2);
        this.publicKey = helpValue1 = helpValue3.mod(modulus);
        LOGGER.debug("Server-Public-Key: {}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)this.publicKey)});
        return this.publicKey;
    }

    public BigInteger calculateX(byte[] salt, byte[] identity, byte[] password) {
        byte[] hashInput1 = DataConverter.concatenate((byte[][])new byte[][]{identity, DataConverter.hexStringToByteArray((String)"3A"), password});
        LOGGER.debug("HashInput for hashInput1: {}", (Object)hashInput1);
        byte[] hashOutput1 = HashCalculator.compute((byte[])hashInput1, (HashAlgorithm)HashAlgorithm.SHA1);
        LOGGER.debug("HashValue for hashInput1: {}", (Object)hashOutput1);
        byte[] hashInput2 = DataConverter.concatenate((byte[][])new byte[][]{salt, hashOutput1});
        LOGGER.debug("HashInput for hashInput2: {}", (Object)hashInput2);
        byte[] hashOutput2 = HashCalculator.compute((byte[])hashInput2, (HashAlgorithm)HashAlgorithm.SHA1);
        LOGGER.debug("HashValue for hashInput2: {}", (Object)hashOutput2);
        return new BigInteger(1, hashOutput2);
    }

    private BigInteger calculateSRP6Multiplier(BigInteger modulus, BigInteger generator) {
        byte[] paddedGenerator = this.calculatePadding(modulus, generator);
        byte[] hashInput = DataConverter.concatenate((byte[][])new byte[][]{DataConverter.bigIntegerToByteArray((BigInteger)modulus), paddedGenerator});
        LOGGER.debug("HashInput SRP6Multi: {}", (Object)hashInput);
        byte[] hashOutput = HashCalculator.compute((byte[])hashInput, (HashAlgorithm)HashAlgorithm.SHA1);
        return new BigInteger(1, hashOutput);
    }

    private byte[] calculatePadding(BigInteger modulus, BigInteger toPad) {
        byte[] paddingArray;
        int modulusByteLength = DataConverter.bigIntegerToByteArray((BigInteger)modulus).length;
        if (modulusByteLength == (paddingArray = DataConverter.bigIntegerToByteArray((BigInteger)toPad)).length) {
            return paddingArray;
        }
        int paddingByteLength = modulusByteLength - paddingArray.length;
        if (paddingByteLength < 0) {
            LOGGER.warn("Padding ByteLength negative, Using Zero instead");
            paddingByteLength = 0;
        }
        byte[] padding = new byte[paddingByteLength];
        return DataConverter.concatenate((byte[][])new byte[][]{padding, paddingArray});
    }

    private byte[] generateToBeSigned() {
        byte[] srpParams = DataConverter.concatenate((byte[][])new byte[][]{DataConverter.intToBytes((int)((Integer)this.msg.getModulusLength().getValue()), (int)2), (byte[])this.msg.getModulus().getValue(), DataConverter.intToBytes((int)((Integer)this.msg.getGeneratorLength().getValue()), (int)2), (byte[])this.msg.getGenerator().getValue(), DataConverter.intToBytes((int)((Integer)this.msg.getSaltLength().getValue()), (int)1), (byte[])this.msg.getSalt().getValue(), DataConverter.intToBytes((int)((Integer)this.msg.getPublicKeyLength().getValue()), (int)2), (byte[])this.msg.getPublicKey().getValue()});
        return DataConverter.concatenate((byte[][])new byte[][]{(byte[])this.msg.getKeyExchangeComputations().getClientServerRandom().getValue(), srpParams});
    }

    private void prepareGenerator(SrpServerKeyExchangeMessage msg) {
        msg.setGenerator(msg.getKeyExchangeComputations().getGenerator().getByteArray());
        LOGGER.debug("Generator: {}", msg.getGenerator().getValue());
    }

    private void prepareModulus(SrpServerKeyExchangeMessage msg) {
        msg.setModulus(msg.getKeyExchangeComputations().getModulus().getByteArray());
        LOGGER.debug("Modulus: {}", msg.getModulus().getValue());
    }

    private void prepareGeneratorLength(SrpServerKeyExchangeMessage msg) {
        msg.setGeneratorLength(((byte[])msg.getGenerator().getValue()).length);
        LOGGER.debug("Generator Length: {}", msg.getGeneratorLength().getValue());
    }

    private void prepareSalt(SrpServerKeyExchangeMessage msg) {
        msg.setSalt(msg.getKeyExchangeComputations().getSalt());
        LOGGER.debug("Salt: {}", msg.getSalt().getValue());
    }

    private void prepareSaltLength(SrpServerKeyExchangeMessage msg) {
        msg.setSaltLength(((byte[])msg.getSalt().getValue()).length);
        LOGGER.debug("Salt Length: {}", msg.getSaltLength().getValue());
    }

    private void prepareModulusLength(SrpServerKeyExchangeMessage msg) {
        msg.setModulusLength(((byte[])msg.getModulus().getValue()).length);
        LOGGER.debug("Modulus Length: {}", msg.getModulusLength().getValue());
    }

    private void preparePublicKey(SrpServerKeyExchangeMessage msg) {
        msg.setPublicKey(this.publicKey.toByteArray());
        LOGGER.debug("PublicKey: {}", msg.getPublicKey().getValue());
    }

    private void preparePublicKeyLength(SrpServerKeyExchangeMessage msg) {
        msg.setPublicKeyLength(((byte[])msg.getPublicKey().getValue()).length);
        LOGGER.debug("PublicKeyLength: {}", msg.getPublicKeyLength().getValue());
    }

    private void setComputedPrivateKey(SrpServerKeyExchangeMessage msg) {
        msg.getKeyExchangeComputations().setPrivateKey(this.chooser.getSRPServerPrivateKey());
        LOGGER.debug("PrivateKey: {}", msg.getKeyExchangeComputations().getPrivateKey().getValue());
    }

    private void setComputedModulus(SrpServerKeyExchangeMessage msg) {
        msg.getKeyExchangeComputations().setModulus(this.chooser.getSRPModulus());
        LOGGER.debug("Modulus used for Computations: {}", (Object)((BigInteger)msg.getKeyExchangeComputations().getModulus().getValue()).toString(16));
    }

    private void setSRPIdentity(SrpServerKeyExchangeMessage msg) {
        msg.getKeyExchangeComputations().setSRPIdentity(this.chooser.getSRPIdentity());
        LOGGER.debug("SRP Identity used for Computations: {}", (Object)msg.getKeyExchangeComputations().getSRPIdentity());
    }

    private void setSRPPassword(SrpServerKeyExchangeMessage msg) {
        msg.getKeyExchangeComputations().setSRPPassword(this.chooser.getSRPPassword());
        LOGGER.debug("SRP Password used for Computations: {}", (Object)msg.getKeyExchangeComputations().getSRPPassword());
    }

    private void setComputedSalt(SrpServerKeyExchangeMessage msg) {
        msg.getKeyExchangeComputations().setSalt(this.chooser.getSRPServerSalt());
        LOGGER.debug("Salt used for Computations: {}", (Object)msg.getKeyExchangeComputations().getSalt());
    }

    private void setComputedGenerator(SrpServerKeyExchangeMessage msg) {
        msg.getKeyExchangeComputations().setGenerator(this.chooser.getSRPGenerator());
        LOGGER.debug("Generator used for Computations: {}", (Object)((BigInteger)msg.getKeyExchangeComputations().getGenerator().getValue()).toString(16));
    }

    private void prepareSignatureAndHashAlgorithm(SrpServerKeyExchangeMessage msg) {
        msg.setSignatureAndHashAlgorithm(this.selectedSignatureHashAlgo.getByteValue());
        LOGGER.debug("SignatureAlgorithm: {}", msg.getSignatureAndHashAlgorithm().getValue());
    }

    private void prepareClientServerRandom(SrpServerKeyExchangeMessage msg) {
        msg.getKeyExchangeComputations().setClientServerRandom(DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()}));
        LOGGER.debug("ClientServerRandom: {}", msg.getKeyExchangeComputations().getClientServerRandom().getValue());
    }

    private void prepareSignature(SrpServerKeyExchangeMessage msg) {
        msg.setSignature(this.signature);
        LOGGER.debug("Signature: {}", msg.getSignature().getValue());
    }

    private void prepareSignatureLength(SrpServerKeyExchangeMessage msg) {
        msg.setSignatureLength(((byte[])msg.getSignature().getValue()).length);
        LOGGER.debug("SignatureLength: {}", msg.getSignatureLength().getValue());
    }
}

