/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class SrpClientKeyExchangePreparator
extends ClientKeyExchangePreparator<SrpClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private BigInteger clientPublicKey;
    private byte[] premasterSecret;
    private byte[] random;
    private final SrpClientKeyExchangeMessage msg;

    public SrpClientKeyExchangePreparator(Chooser chooser, SrpClientKeyExchangeMessage msg) {
        super(chooser, msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing SRPClientExchangeMessage");
        this.msg.prepareComputations();
        this.setComputationGenerator(this.msg);
        this.setComputationModulus(this.msg);
        this.setComputationPrivateKey(this.msg);
        this.setComputationServerPublicKey(this.msg);
        this.setComputationSalt(this.msg);
        this.setSRPIdentity(this.msg);
        this.setSRPPassword(this.msg);
        this.clientPublicKey = this.calculatePublicKey((BigInteger)this.msg.getComputations().getGenerator().getValue(), (BigInteger)this.msg.getComputations().getModulus().getValue(), (BigInteger)this.msg.getComputations().getPrivateKey().getValue());
        this.prepareModulus(this.msg);
        this.prepareModulusLength(this.msg);
        this.prepareGenerator(this.msg);
        this.prepareGeneratorLength(this.msg);
        this.prepareSalt(this.msg);
        this.prepareSaltLength(this.msg);
        this.preparePublicKey(this.msg);
        this.preparePublicKeyLength(this.msg);
        this.premasterSecret = this.calculateClientPremasterSecret((BigInteger)this.msg.getComputations().getModulus().getValue(), (BigInteger)this.msg.getComputations().getGenerator().getValue(), (BigInteger)this.msg.getComputations().getPrivateKey().getValue(), (BigInteger)this.msg.getComputations().getServerPublicKey().getValue(), this.clientPublicKey, (byte[])this.msg.getComputations().getSalt().getValue(), (byte[])this.msg.getComputations().getSRPIdentity().getValue(), (byte[])this.msg.getComputations().getSRPPassword().getValue());
        this.preparePremasterSecret(this.msg);
        this.prepareClientServerRandom(this.msg);
    }

    private BigInteger calculatePublicKey(BigInteger generator, BigInteger modulus, BigInteger privateKey) {
        if (modulus.compareTo(BigInteger.ZERO) == 1) {
            return generator.modPow(privateKey, modulus);
        }
        LOGGER.warn("Modulusis smaller than zero, using zero as the public key");
        return BigInteger.ZERO;
    }

    private byte[] calculateClientPremasterSecret(BigInteger modulus, BigInteger generator, BigInteger privateKey, BigInteger serverPublicKey, BigInteger clientPublicKey, byte[] salt, byte[] identity, byte[] password) {
        if (modulus.compareTo(BigInteger.ZERO) == 1) {
            BigInteger u = this.calculateU(clientPublicKey, serverPublicKey, modulus);
            LOGGER.debug("Intermediate Value U{}", (Object)DataConverter.bigIntegerToByteArray((BigInteger)u));
            BigInteger k = this.calculateSRP6Multiplier(modulus, generator);
            BigInteger x = this.calculateX(salt, identity, password);
            LOGGER.debug("Intermediate Value X{}", (Object)DataConverter.bigIntegerToByteArray((BigInteger)x));
            BigInteger helpValue1 = generator.modPow(x, modulus);
            LOGGER.debug("Intermediate Value V{}", (Object)DataConverter.bigIntegerToByteArray((BigInteger)helpValue1));
            BigInteger helpValue2 = k.multiply(helpValue1);
            BigInteger helpValue3 = helpValue2.mod(modulus);
            helpValue1 = serverPublicKey.subtract(helpValue3);
            helpValue2 = helpValue1.mod(modulus);
            helpValue3 = u.multiply(x);
            helpValue1 = helpValue3.mod(modulus);
            helpValue3 = privateKey.add(helpValue1);
            helpValue1 = helpValue3.mod(modulus);
            helpValue3 = helpValue2.modPow(helpValue1, modulus);
            return DataConverter.bigIntegerToByteArray((BigInteger)helpValue3);
        }
        LOGGER.warn("Modulus is smaller than zero, using new byte[0] as the pms");
        return new byte[0];
    }

    private byte[] calculatePremasterSecretServer(BigInteger modulus, BigInteger generator, BigInteger serverPrivateKey, BigInteger serverPublicKey, BigInteger clientPublicKey, byte[] salt, byte[] identity, byte[] password) {
        BigInteger u = this.calculateU(clientPublicKey, serverPublicKey, modulus);
        LOGGER.debug("Intermediate Value U{}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)u)});
        BigInteger x = this.calculateX(salt, identity, password);
        LOGGER.debug("Intermediate Value X{}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)x)});
        BigInteger v = this.calculateV(x, generator, modulus);
        LOGGER.debug("Intermediate Value V{}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)v)});
        BigInteger helpValue1 = v.modPow(u, modulus);
        LOGGER.debug("v^u{}", (Object)DataConverter.bigIntegerToByteArray((BigInteger)helpValue1));
        BigInteger helpValue2 = clientPublicKey.multiply(helpValue1);
        BigInteger helpValue3 = helpValue2.mod(modulus);
        LOGGER.debug("A * v^u{}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)helpValue3)});
        helpValue1 = helpValue3.modPow(serverPrivateKey, modulus);
        LOGGER.debug("PremasterSecret{}", (Object)DataConverter.bigIntegerToByteArray((BigInteger)helpValue1));
        return DataConverter.bigIntegerToByteArray((BigInteger)helpValue1);
    }

    private BigInteger calculateV(BigInteger x, BigInteger generator, BigInteger modulus) {
        BigInteger v = generator.modPow(x, modulus);
        return v;
    }

    private BigInteger calculateU(BigInteger clientPublic, BigInteger serverPublic, BigInteger modulus) {
        byte[] paddedClientPublic = this.calculatePadding(modulus, clientPublic);
        LOGGER.debug("ClientPublic Key:{}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)clientPublic)});
        LOGGER.debug("PaddedClientPublic. {}", (Object)paddedClientPublic);
        byte[] paddedServerPublic = this.calculatePadding(modulus, serverPublic);
        LOGGER.debug("ServerPublic Key:{}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)serverPublic)});
        LOGGER.debug("PaddedServerPublic. {}", (Object)paddedServerPublic);
        byte[] hashInput = DataConverter.concatenate((byte[][])new byte[][]{paddedClientPublic, paddedServerPublic});
        LOGGER.debug("HashInput for u: {}", (Object)hashInput);
        byte[] hashOutput = this.shaSum(hashInput);
        LOGGER.debug("HashValue for u: {}", (Object)hashOutput);
        return new BigInteger(1, hashOutput);
    }

    private byte[] calculatePadding(BigInteger modulus, BigInteger toPad) {
        byte[] paddingArray;
        int modulusByteLength = DataConverter.bigIntegerToByteArray((BigInteger)modulus).length;
        if (modulusByteLength == (paddingArray = DataConverter.bigIntegerToByteArray((BigInteger)toPad)).length) {
            return paddingArray;
        }
        int paddingByteLength = modulusByteLength - paddingArray.length;
        if (paddingByteLength < 0) {
            LOGGER.warn("Negative SRP Padding Size. Using 0");
            paddingByteLength = 0;
        }
        byte[] padding = new byte[paddingByteLength];
        return DataConverter.concatenate((byte[][])new byte[][]{padding, paddingArray});
    }

    public BigInteger calculateX(byte[] salt, byte[] identity, byte[] password) {
        byte[] hashInput1 = DataConverter.concatenate((byte[][])new byte[][]{identity, DataConverter.hexStringToByteArray((String)"3A"), password});
        LOGGER.debug("HashInput for hashInput1: {}", (Object)hashInput1);
        byte[] hashOutput1 = this.shaSum(hashInput1);
        LOGGER.debug("HashValue for hashInput1: {}", (Object)hashOutput1);
        byte[] hashInput2 = DataConverter.concatenate((byte[][])new byte[][]{salt, hashOutput1});
        LOGGER.debug("HashInput for hashInput2: {}", (Object)hashInput2);
        byte[] hashOutput2 = this.shaSum(hashInput2);
        LOGGER.debug("HashValue for hashInput2: {}", (Object)hashOutput2);
        return new BigInteger(1, hashOutput2);
    }

    private BigInteger calculateSRP6Multiplier(BigInteger modulus, BigInteger generator) {
        byte[] paddedGenerator = this.calculatePadding(modulus, generator);
        byte[] hashInput = DataConverter.concatenate((byte[][])new byte[][]{DataConverter.bigIntegerToByteArray((BigInteger)modulus), paddedGenerator});
        LOGGER.debug("HashInput SRP6Multi: {}", (Object)hashInput);
        byte[] hashOutput = this.shaSum(hashInput);
        return new BigInteger(1, hashOutput);
    }

    public byte[] shaSum(byte[] toHash) {
        MessageDigest dig = null;
        try {
            dig = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptoException("SHA1 is not availble");
        }
        dig.update(toHash);
        return dig.digest();
    }

    private void setComputationGenerator(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setGenerator(this.chooser.getSRPGenerator());
        LOGGER.debug("Generator: {}", msg.getComputations().getGenerator().getValue());
    }

    private void setComputationModulus(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setModulus(this.chooser.getSRPModulus());
        LOGGER.debug("Modulus: {}", msg.getComputations().getModulus().getValue());
    }

    private void preparePremasterSecret(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setPremasterSecret(this.premasterSecret);
        this.premasterSecret = (byte[])msg.getComputations().getPremasterSecret().getValue();
        LOGGER.debug("PremasterSecret: {}", msg.getComputations().getPremasterSecret().getValue());
    }

    private void preparePublicKey(SrpClientKeyExchangeMessage msg) {
        msg.setPublicKey(this.clientPublicKey.toByteArray());
        LOGGER.debug("PublicKey: {}", msg.getPublicKey().getValue());
    }

    private void preparePublicKeyLength(SrpClientKeyExchangeMessage msg) {
        msg.setPublicKeyLength(((byte[])msg.getPublicKey().getValue()).length);
        LOGGER.debug("PublicKeyLength: {}", msg.getPublicKeyLength().getValue());
    }

    private void prepareClientServerRandom(SrpClientKeyExchangeMessage msg) {
        this.random = DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        msg.getComputations().setClientServerRandom(this.random);
        this.random = (byte[])msg.getComputations().getClientServerRandom().getValue();
        LOGGER.debug("ClientServerRandom: {}", msg.getComputations().getClientServerRandom().getValue());
    }

    @Override
    public void prepareAfterParse() {
        BigInteger privateKey = this.chooser.getSRPServerPrivateKey();
        BigInteger clientPublic = new BigInteger(1, (byte[])this.msg.getPublicKey().getValue());
        this.msg.prepareComputations();
        this.premasterSecret = this.calculatePremasterSecretServer(this.chooser.getSRPModulus(), this.chooser.getSRPGenerator(), privateKey, this.chooser.getSRPServerPublicKey(), clientPublic, this.chooser.getSRPServerSalt(), this.chooser.getSRPIdentity(), this.chooser.getSRPPassword());
        this.preparePremasterSecret(this.msg);
        this.prepareClientServerRandom(this.msg);
    }

    private void setComputationPrivateKey(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setPrivateKey(this.chooser.getSRPClientPrivateKey());
        LOGGER.debug("Computation PrivateKey: " + ((BigInteger)msg.getComputations().getPrivateKey().getValue()).toString());
    }

    private void setComputationServerPublicKey(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setServerPublicKey(this.chooser.getSRPServerPublicKey());
        LOGGER.debug("Computation PublicKey: " + ((BigInteger)msg.getComputations().getServerPublicKey().getValue()).toString());
    }

    private void prepareSalt(SrpClientKeyExchangeMessage msg) {
        msg.setSalt(msg.getComputations().getSalt());
        LOGGER.debug("Salt: {}", msg.getSalt().getValue());
    }

    private void prepareSaltLength(SrpClientKeyExchangeMessage msg) {
        msg.setSaltLength(((byte[])msg.getSalt().getValue()).length);
        LOGGER.debug("Salt Length: {}", msg.getSaltLength().getValue());
    }

    private void setSRPIdentity(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setSRPIdentity(this.chooser.getSRPIdentity());
        LOGGER.debug("SRP Identity used for Computations: " + String.valueOf(msg.getComputations().getSRPIdentity()));
    }

    private void setSRPPassword(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setSRPPassword(this.chooser.getSRPPassword());
        LOGGER.debug("SRP Password used for Computations: " + String.valueOf(msg.getComputations().getSRPPassword()));
    }

    private void setComputationSalt(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setSalt(this.chooser.getSRPServerSalt());
        LOGGER.debug("Salt used for Computations: {}", (Object)msg.getComputations().getSalt());
    }

    private void prepareGenerator(SrpClientKeyExchangeMessage msg) {
        msg.setGenerator(msg.getComputations().getGenerator().getByteArray());
        LOGGER.debug("Generator: {}", msg.getGenerator().getValue());
    }

    private void prepareModulus(SrpClientKeyExchangeMessage msg) {
        msg.setModulus(msg.getComputations().getModulus().getByteArray());
        LOGGER.debug("Modulus: {}", msg.getModulus().getValue());
    }

    private void prepareGeneratorLength(SrpClientKeyExchangeMessage msg) {
        msg.setGeneratorLength(((byte[])msg.getGenerator().getValue()).length);
        LOGGER.debug("Generator Length: {}", msg.getGeneratorLength().getValue());
    }

    private void prepareModulusLength(SrpClientKeyExchangeMessage msg) {
        msg.setModulusLength(((byte[])msg.getModulus().getValue()).length);
        LOGGER.debug("Modulus Length: {}", msg.getModulusLength().getValue());
    }
}

