/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2MessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ClientHelloPreparator
extends SSL2MessagePreparator<SSL2ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SSL2ClientHelloMessage message;

    public SSL2ClientHelloPreparator(Chooser chooser, SSL2ClientHelloMessage message) {
        super(chooser, message);
        this.message = message;
    }

    @Override
    protected void prepareProtocolMessageContents() {
        LOGGER.debug("Prepare SSL2ClientHello");
        this.preparePaddingLength(this.message);
        this.prepareType(this.message);
        this.prepareProtocolVersion(this.message);
        this.prepareCipherSuites(this.message);
        byte[] challenge = new byte[16];
        this.chooser.getContext().getTlsContext().getRandom().nextBytes(challenge);
        this.prepareChallenge(this.message, challenge);
        this.prepareSessionID(this.message);
        this.prepareSessionIDLength(this.message);
        this.prepareChallengeLength(this.message);
        this.prepareCipherSuiteLength(this.message);
        int length = 7;
        length += ((byte[])this.message.getChallenge().getValue()).length;
        length += ((byte[])this.message.getCipherSuites().getValue()).length;
        length += ((byte[])this.message.getSessionId().getValue()).length;
        this.prepareMessageLength(this.message, length += ((byte[])this.message.getProtocolVersion().getValue()).length);
    }

    private void preparePaddingLength(SSL2ClientHelloMessage message) {
        message.setPaddingLength(0);
        LOGGER.debug("PaddingLength: {}", message.getPaddingLength().getValue());
    }

    private void prepareType(SSL2ClientHelloMessage message) {
        message.setType(message.getSsl2MessageType().getType());
        LOGGER.debug("Type: {}", message.getType().getValue());
    }

    private void prepareProtocolVersion(SSL2ClientHelloMessage message) {
        message.setProtocolVersion(this.chooser.getConfig().getHighestProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: {}", message.getProtocolVersion().getValue());
    }

    private void prepareCipherSuites(SSL2ClientHelloMessage message) {
        SilentByteArrayOutputStream cipherStream = new SilentByteArrayOutputStream();
        for (SSL2CipherSuite suite : SSL2CipherSuite.values()) {
            if (suite == SSL2CipherSuite.SSL_UNKNOWN_CIPHER) continue;
            cipherStream.write(suite.getByteValue());
        }
        message.setCipherSuites(cipherStream.toByteArray());
        LOGGER.debug("CipherSuites: {}", message.getCipherSuites().getValue());
    }

    private void prepareChallenge(SSL2ClientHelloMessage message, byte[] challenge) {
        message.setChallenge(challenge);
        LOGGER.debug("Challenge: {}", message.getChallenge().getValue());
    }

    private void prepareSessionID(SSL2ClientHelloMessage message) {
        message.setSessionID(this.chooser.getClientSessionId());
        LOGGER.debug("SessionID: {}", message.getSessionId().getValue());
    }

    private void prepareSessionIDLength(SSL2ClientHelloMessage message) {
        message.setSessionIDLength(((byte[])message.getSessionId().getValue()).length);
        LOGGER.debug("SessionIDLength: {}", message.getSessionIdLength().getValue());
    }

    private void prepareChallengeLength(SSL2ClientHelloMessage message) {
        message.setChallengeLength(((byte[])message.getChallenge().getValue()).length);
        LOGGER.debug("ChallengeLength: {}", message.getChallengeLength().getValue());
    }

    private void prepareCipherSuiteLength(SSL2ClientHelloMessage message) {
        message.setCipherSuiteLength(((byte[])message.getCipherSuites().getValue()).length);
        LOGGER.debug("CipherSuiteLength: {}", message.getCipherSuiteLength().getValue());
    }

    private void prepareMessageLength(SSL2ClientHelloMessage message, int length) {
        message.setMessageLength(length);
        LOGGER.debug("MessageLength: {}", message.getMessageLength().getValue());
    }
}

