/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.message.RSAServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.selection.SignatureAndHashAlgorithmSelector;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSAServerKeyExchangePreparator<T extends RSAServerKeyExchangeMessage>
extends ServerKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected SignatureAndHashAlgorithm selectedSignatureHashAlgo;
    protected byte[] signature;
    protected final T msg;

    public RSAServerKeyExchangePreparator(Chooser chooser, T message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    protected void prepareHandshakeMessageContents() {
        this.setRsaParams();
        this.prepareRsaParams();
        this.selectedSignatureHashAlgo = SignatureAndHashAlgorithmSelector.selectSignatureAndHashAlgorithm(this.chooser, false);
        this.prepareSignatureAndHashAlgorithm(this.msg);
        this.signature = this.generateSignature(this.selectedSignatureHashAlgo, this.generateToBeSigned());
        this.prepareSignature(this.msg);
        this.prepareSignatureLength(this.msg);
    }

    protected void setRsaParams() {
        ((RSAServerKeyExchangeMessage)this.msg).prepareKeyExchangeComputations();
        ((RSAServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().setPrivateKey(this.chooser.getConfig().getDefaultServerEphemeralRsaExportPrivateKey());
        ((RSAServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().setModulus(this.chooser.getConfig().getDefaultServerEphemeralRsaExportModulus());
        ((RSAServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().setPublicExponent(this.chooser.getConfig().getDefaultServerEphemeralRsaExportModulus());
    }

    protected void prepareRsaParams() {
        ((RSAServerKeyExchangeMessage)this.msg).setModulus(((RSAServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().getModulus().getByteArray());
        ((RSAServerKeyExchangeMessage)this.msg).setModulusLength(((byte[])((RSAServerKeyExchangeMessage)this.msg).getModulus().getValue()).length);
        ((ServerKeyExchangeMessage)this.msg).setPublicKey(((RSAServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().getPublicExponent().getByteArray());
        ((ServerKeyExchangeMessage)this.msg).setPublicKeyLength(((byte[])((ServerKeyExchangeMessage)this.msg).getPublicKey().getValue()).length);
        this.prepareClientServerRandom(this.msg);
    }

    protected byte[] generateToBeSigned() {
        byte[] rsaParams = DataConverter.concatenate((byte[][])new byte[][]{DataConverter.intToBytes((int)((Integer)((RSAServerKeyExchangeMessage)this.msg).getModulusLength().getValue()), (int)2), (byte[])((RSAServerKeyExchangeMessage)this.msg).getModulus().getValue(), DataConverter.intToBytes((int)((Integer)((ServerKeyExchangeMessage)this.msg).getPublicKeyLength().getValue()), (int)2), (byte[])((ServerKeyExchangeMessage)this.msg).getPublicKey().getValue()});
        return DataConverter.concatenate((byte[][])new byte[][]{(byte[])((RSAServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().getClientServerRandom().getValue(), rsaParams});
    }

    protected void prepareSignatureAndHashAlgorithm(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignatureAndHashAlgorithm(this.selectedSignatureHashAlgo.getByteValue());
        LOGGER.debug("SignatureAlgorithm: {}", ((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue());
    }

    protected void prepareClientServerRandom(T msg) {
        ((RSAServerKeyExchangeMessage)msg).getKeyExchangeComputations().setClientServerRandom(DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()}));
        LOGGER.debug("ClientServerRandom: {}", ((RSAServerKeyExchangeMessage)msg).getKeyExchangeComputations().getClientServerRandom().getValue());
    }

    protected void prepareSignature(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignature(this.signature);
        LOGGER.debug("Signatur: {}", ((ServerKeyExchangeMessage)msg).getSignature().getValue());
    }

    protected void prepareSignatureLength(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignatureLength(((byte[])((ServerKeyExchangeMessage)msg).getSignature().getValue()).length);
        LOGGER.debug("SignatureLength: {}", ((ServerKeyExchangeMessage)msg).getSignatureLength().getValue());
    }
}

