/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.message.PskClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskClientKeyExchangePreparator
extends ClientKeyExchangePreparator<PskClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private byte[] premasterSecret;
    private byte[] clientRandom;
    private final PskClientKeyExchangeMessage msg;
    private SilentByteArrayOutputStream outputStream;

    public PskClientKeyExchangePreparator(Chooser chooser, PskClientKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.setIdentity(this.chooser.getPSKIdentity());
        this.msg.setIdentityLength(((byte[])this.msg.getIdentity().getValue()).length);
        this.msg.prepareComputations();
        this.premasterSecret = this.generatePremasterSecret();
        this.preparePremasterSecret(this.msg);
        this.prepareClientServerRandom(this.msg);
    }

    public byte[] generatePremasterSecret() {
        byte[] psk = this.chooser.getConfig().getDefaultPSKKey();
        this.outputStream = new SilentByteArrayOutputStream();
        this.outputStream.write(DataConverter.intToBytes((int)psk.length, (int)2));
        if (psk.length > 0) {
            this.outputStream.write(DataConverter.intToBytes((int)0, (int)psk.length));
        }
        this.outputStream.write(DataConverter.intToBytes((int)psk.length, (int)2));
        this.outputStream.write(psk);
        byte[] tempPremasterSecret = this.outputStream.toByteArray();
        return tempPremasterSecret;
    }

    private void preparePremasterSecret(PskClientKeyExchangeMessage msg) {
        msg.getComputations().setPremasterSecret(this.premasterSecret);
        LOGGER.debug("PremasterSecret: {}", msg.getComputations().getPremasterSecret().getValue());
    }

    private void prepareClientServerRandom(PskClientKeyExchangeMessage msg) {
        this.clientRandom = DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        msg.getComputations().setClientServerRandom(this.clientRandom);
        LOGGER.debug("ClientServerRandom: {}", msg.getComputations().getClientServerRandom().getValue());
    }

    @Override
    public void prepareAfterParse() {
        this.msg.prepareComputations();
        this.premasterSecret = this.generatePremasterSecret();
        this.preparePremasterSecret(this.msg);
        this.prepareClientServerRandom(this.msg);
    }
}

