/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.constants.PointFormat;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.EllipticCurveOverFp;
import de.rub.nds.protocol.crypto.ec.EllipticCurveSECP256R1;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.PreparationException;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.EllipticCurveType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PWDComputations;
import de.rub.nds.tlsattacker.core.protocol.preparator.ServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PWDServerKeyExchangePreparator
extends ServerKeyExchangePreparator<PWDServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final PWDServerKeyExchangeMessage msg;

    public PWDServerKeyExchangePreparator(Chooser chooser, PWDServerKeyExchangeMessage msg) {
        super(chooser, msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing PWDServerKeyExchangeMessage");
        this.msg.prepareKeyExchangeComputations();
        this.prepareCurveType(this.msg);
        NamedGroup group = this.selectNamedGroup(this.msg);
        this.msg.setNamedGroup(group.getValue());
        this.prepareSalt(this.msg);
        this.prepareSaltLength(this.msg);
        try {
            this.preparePasswordElement(this.msg);
        }
        catch (CryptoException e) {
            throw new PreparationException("Failed to generate password element", (Throwable)e);
        }
        this.prepareScalarElement(this.msg);
    }

    protected void preparePasswordElement(PWDServerKeyExchangeMessage msg) throws CryptoException {
        EllipticCurve curve;
        NamedGroup namedGroup = this.selectNamedGroup(msg);
        CyclicGroup group = namedGroup.getGroupParameters().getGroup();
        if (group instanceof EllipticCurve) {
            curve = (EllipticCurve)group;
        } else {
            LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
            curve = new EllipticCurveSECP256R1();
        }
        Point passwordElement = PWDComputations.computePasswordElement(this.chooser, curve);
        msg.getKeyExchangeComputations().setPasswordElement(passwordElement);
        LOGGER.debug("PasswordElement.x: {}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)passwordElement.getFieldX().getData())});
    }

    protected NamedGroup selectNamedGroup(PWDServerKeyExchangeMessage msg) {
        NamedGroup namedGroup;
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            namedGroup = this.chooser.getConfig().getDefaultSelectedNamedGroup();
        } else {
            EllipticCurve curve;
            CyclicGroup group;
            NamedGroup tempNamedGroup;
            int i;
            HashSet<NamedGroup> serverSet = new HashSet<NamedGroup>();
            HashSet<NamedGroup> clientSet = new HashSet<NamedGroup>();
            for (i = 0; i < this.chooser.getClientSupportedNamedGroups().size(); ++i) {
                tempNamedGroup = this.chooser.getClientSupportedNamedGroups().get(i);
                if (!tempNamedGroup.isShortWeierstrass()) continue;
                group = tempNamedGroup.getGroupParameters().getGroup();
                if (group instanceof EllipticCurve) {
                    curve = (EllipticCurve)group;
                } else {
                    LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
                    curve = new EllipticCurveSECP256R1();
                }
                if (!(curve instanceof EllipticCurveOverFp)) continue;
                clientSet.add(tempNamedGroup);
            }
            for (i = 0; i < this.chooser.getConfig().getDefaultServerNamedGroups().size(); ++i) {
                tempNamedGroup = this.chooser.getConfig().getDefaultServerNamedGroups().get(i);
                if (!tempNamedGroup.isShortWeierstrass()) continue;
                group = this.chooser.getSelectedNamedGroup().getGroupParameters().getGroup();
                if (group instanceof EllipticCurve) {
                    curve = (EllipticCurve)group;
                } else {
                    LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
                    curve = new EllipticCurveSECP256R1();
                }
                if (!(curve instanceof EllipticCurveOverFp)) continue;
                serverSet.add(tempNamedGroup);
            }
            serverSet.retainAll(clientSet);
            if (serverSet.isEmpty()) {
                LOGGER.warn("No common NamedGroup - falling back to default");
                namedGroup = this.chooser.getConfig().getDefaultSelectedNamedGroup();
            } else {
                namedGroup = serverSet.contains((Object)this.chooser.getConfig().getDefaultSelectedNamedGroup()) ? this.chooser.getConfig().getDefaultSelectedNamedGroup() : (NamedGroup)((Object)serverSet.toArray()[0]);
            }
        }
        return namedGroup;
    }

    protected void prepareSalt(PWDServerKeyExchangeMessage msg) {
        msg.setSalt(this.chooser.getConfig().getDefaultServerPWDSalt());
        LOGGER.debug("Salt: {}", msg.getSalt().getValue());
    }

    protected void prepareSaltLength(PWDServerKeyExchangeMessage msg) {
        msg.setSaltLength(((byte[])msg.getSalt().getValue()).length);
        LOGGER.debug("SaltLength: {}", msg.getSaltLength().getValue());
    }

    protected void prepareCurveType(PWDServerKeyExchangeMessage msg) {
        msg.setCurveType(EllipticCurveType.NAMED_CURVE.getValue());
    }

    protected List<ECPointFormat> getPointFormatList() {
        List<ECPointFormat> sharedPointFormats = new ArrayList<ECPointFormat>(this.chooser.getServerSupportedPointFormats());
        if (sharedPointFormats.isEmpty()) {
            LOGGER.warn("Don't know which point format to use for PWD. Check if pointFormats is set in config.");
            sharedPointFormats = this.chooser.getConfig().getDefaultServerSupportedPointFormats();
        }
        ArrayList<ECPointFormat> unsupportedFormats = new ArrayList<ECPointFormat>();
        if (!this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            List<ECPointFormat> clientPointFormats = this.chooser.getClientSupportedPointFormats();
            for (ECPointFormat f : sharedPointFormats) {
                if (clientPointFormats.contains((Object)f)) continue;
                unsupportedFormats.add(f);
            }
        }
        sharedPointFormats.removeAll(unsupportedFormats);
        if (sharedPointFormats.isEmpty()) {
            sharedPointFormats = new ArrayList<ECPointFormat>(this.chooser.getConfig().getDefaultServerSupportedPointFormats());
        }
        return sharedPointFormats;
    }

    protected void prepareScalarElement(PWDServerKeyExchangeMessage msg) {
        EllipticCurve curve;
        CyclicGroup group = this.selectNamedGroup(msg).getGroupParameters().getGroup();
        if (group instanceof EllipticCurve) {
            curve = (EllipticCurve)group;
        } else {
            LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
            curve = new EllipticCurveSECP256R1();
        }
        PWDComputations.PWDKeyMaterial keyMaterial = PWDComputations.generateKeyMaterial(curve, msg.getKeyExchangeComputations().getPasswordElement(), this.chooser);
        msg.getKeyExchangeComputations().setPrivateKeyScalar(keyMaterial.privateKeyScalar);
        LOGGER.debug("Private: {}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)keyMaterial.privateKeyScalar)});
        this.prepareScalar(msg, keyMaterial.scalar);
        this.prepareScalarLength(msg);
        this.prepareElement(msg, keyMaterial.element);
        this.prepareElementLength(msg);
    }

    protected void prepareScalar(PWDServerKeyExchangeMessage msg, BigInteger scalar) {
        msg.setScalar(DataConverter.bigIntegerToByteArray((BigInteger)scalar));
        LOGGER.debug("Scalar: {}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)scalar)});
    }

    protected void prepareScalarLength(PWDServerKeyExchangeMessage msg) {
        msg.setScalarLength(((byte[])msg.getScalar().getValue()).length);
        LOGGER.debug("ScalarLength: {}", (Object)msg.getScalarLength());
    }

    protected void prepareElement(PWDServerKeyExchangeMessage msg, Point element) {
        byte[] serializedElement = PointFormatter.formatToByteArray((GroupParameters)((NamedEllipticCurveParameters)this.chooser.getConfig().getDefaultSelectedNamedGroup().getGroupParameters()), (Point)element, (PointFormat)this.chooser.getConfig().getDefaultSelectedPointFormat().getFormat());
        msg.setElement(serializedElement);
        LOGGER.debug("Element: {}", (Object)serializedElement);
    }

    protected void prepareElementLength(PWDServerKeyExchangeMessage msg) {
        msg.setElementLength(((byte[])msg.getElement().getValue()).length);
        LOGGER.debug("ElementLength: {}", (Object)msg.getElementLength());
    }
}

