/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.crypto.PseudoRandomFunction;
import de.rub.nds.tlsattacker.core.crypto.SSLUtils;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class FinishedPreparator
extends HandshakeMessagePreparator<FinishedMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private byte[] verifyData;
    private final FinishedMessage msg;

    public FinishedPreparator(Chooser chooser, FinishedMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing FinishedMessage");
        try {
            this.verifyData = this.computeVerifyData();
        }
        catch (CryptoException ex) {
            LOGGER.warn("Could not compute VerifyData! Using empty verifyData.", (Throwable)ex);
            this.verifyData = new byte[0];
        }
        this.prepareVerifyData(this.msg);
    }

    private byte[] computeVerifyData() throws CryptoException {
        if (this.chooser.getSelectedProtocolVersion().is13()) {
            try {
                byte[] result;
                HKDFAlgorithm hkdfAlgorithm = AlgorithmResolver.getHKDFAlgorithm(this.chooser.getSelectedCipherSuite());
                String javaMacName = hkdfAlgorithm.getMacAlgorithm().getJavaName();
                boolean isHmacSM3 = javaMacName.equals("HmacSM3");
                int macLength = isHmacSM3 ? 32 : Mac.getInstance(javaMacName).getMacLength();
                LOGGER.debug("Connection End: {}", (Object)this.chooser.getTalkingConnectionEnd());
                byte[] trafficSecret = this.chooser.getTalkingConnectionEnd() == ConnectionEndType.SERVER ? this.chooser.getServerHandshakeTrafficSecret() : this.chooser.getClientHandshakeTrafficSecret();
                byte[] finishedKey = HKDFunction.expandLabel(hkdfAlgorithm, trafficSecret, "finished", new byte[0], macLength, this.chooser.getSelectedProtocolVersion());
                LOGGER.debug("Finished key: {}", (Object)finishedKey);
                SecretKeySpec keySpec = new SecretKeySpec(finishedKey, javaMacName);
                if (isHmacSM3) {
                    HMac hmac = new HMac((Digest)new SM3Digest());
                    KeyParameter keyParameter = new KeyParameter(keySpec.getEncoded());
                    hmac.init((CipherParameters)keyParameter);
                    hmac.update(this.chooser.getContext().getTlsContext().getDigest().digest(this.chooser.getSelectedProtocolVersion(), this.chooser.getSelectedCipherSuite()), 0, 32);
                    result = new byte[hmac.getMacSize()];
                    hmac.doFinal(result, 0);
                } else {
                    Mac mac = Mac.getInstance(javaMacName);
                    mac.init(keySpec);
                    mac.update(this.chooser.getContext().getTlsContext().getDigest().digest(this.chooser.getSelectedProtocolVersion(), this.chooser.getSelectedCipherSuite()));
                    result = mac.doFinal();
                }
                return result;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException ex) {
                throw new CryptoException((Throwable)ex);
            }
        }
        if (this.chooser.getSelectedProtocolVersion().isSSL()) {
            LOGGER.trace("Calculating VerifyData:");
            byte[] handshakeMessageContent = this.chooser.getContext().getTlsContext().getDigest().getRawBytes();
            byte[] masterSecret = this.chooser.getMasterSecret();
            LOGGER.debug("Using MasterSecret: {}", (Object)masterSecret);
            ConnectionEndType endType = this.chooser.getTalkingConnectionEnd();
            return SSLUtils.calculateFinishedData(handshakeMessageContent, masterSecret, endType);
        }
        LOGGER.debug("Calculating VerifyData:");
        PRFAlgorithm prfAlgorithm = this.chooser.getPRFAlgorithm();
        LOGGER.debug("Using PRF: {}", (Object)prfAlgorithm.name());
        byte[] masterSecret = this.chooser.getMasterSecret();
        LOGGER.debug("Using MasterSecret: {}", (Object)masterSecret);
        byte[] handshakeMessageHash = this.chooser.getContext().getTlsContext().getDigest().digest(this.chooser.getSelectedProtocolVersion(), this.chooser.getSelectedCipherSuite());
        LOGGER.debug("Using HandshakeMessage Hash: {}", (Object)handshakeMessageHash);
        String label = this.chooser.getTalkingConnectionEnd() == ConnectionEndType.SERVER ? "server finished" : "client finished";
        byte[] res = PseudoRandomFunction.compute(prfAlgorithm, masterSecret, label, handshakeMessageHash, 12);
        return res;
    }

    private void prepareVerifyData(FinishedMessage msg) {
        msg.setVerifyData(this.verifyData);
        LOGGER.debug("VerifyData: {}", msg.getVerifyData().getValue());
    }
}

