/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.EllipticCurveSECP256R1;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.message.EmptyClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.BigIntegers;

public class EmptyClientKeyExchangePreparator<T extends EmptyClientKeyExchangeMessage>
extends ClientKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected byte[] random;
    protected final T msg;
    protected byte[] premasterSecret;

    public EmptyClientKeyExchangePreparator(Chooser chooser, T msg) {
        super(chooser, msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing EmptyClientKeyExchangeMessage");
        this.prepareAfterParse();
    }

    protected void prepareClientServerRandom(T msg) {
        this.random = DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        ((EmptyClientKeyExchangeMessage)msg).getComputations().setClientServerRandom(this.random);
        this.random = (byte[])((EmptyClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue();
        LOGGER.debug("ClientServerRandom: {}", ((EmptyClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue());
    }

    protected byte[] calculateDhPremasterSecret(BigInteger modulus, BigInteger privateKey, BigInteger publicKey) {
        if (modulus.compareTo(BigInteger.ZERO) == 0) {
            LOGGER.warn("Modulus is ZERO. Returning empty premaster Secret");
            return new byte[0];
        }
        return BigIntegers.asUnsignedByteArray((BigInteger)publicKey.modPow(privateKey.abs(), modulus.abs()));
    }

    protected void preparePremasterSecret(T msg) {
        ((EmptyClientKeyExchangeMessage)msg).getComputations().setPremasterSecret(this.premasterSecret);
        this.premasterSecret = (byte[])((EmptyClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue();
        LOGGER.debug("PremasterSecret: {}", ((EmptyClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue());
    }

    protected byte[] computeECPremasterSecret(EllipticCurve curve, Point publicKey, BigInteger privateKey) {
        Point sharedPoint = curve.mult(privateKey, publicKey);
        int elementLength = DataConverter.bigIntegerToByteArray((BigInteger)sharedPoint.getFieldX().getModulus()).length;
        return DataConverter.bigIntegerToNullPaddedByteArray((BigInteger)sharedPoint.getFieldX().getData(), (int)elementLength);
    }

    @Override
    public void prepareAfterParse() {
        ((EmptyClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        if (this.chooser.getContext().getTlsContext().getClientCertificateChain() != null && !this.chooser.getContext().getTlsContext().getClientCertificateChain().getCertificateList().isEmpty()) {
            X509PublicKeyType certificateKeyType = this.chooser.getContext().getTlsContext().getClientCertificateChain().getLeaf().getCertificateKeyType();
            KeyExchangeAlgorithm keyExchangeAlgorithm = this.chooser.getSelectedCipherSuite().getKeyExchangeAlgorithm();
            if (keyExchangeAlgorithm != null && (keyExchangeAlgorithm.isKeyExchangeDh() || keyExchangeAlgorithm.isKeyExchangeDhe())) {
                this.computeDhKeyExchangePms();
            } else if (keyExchangeAlgorithm != null && keyExchangeAlgorithm.isEC()) {
                this.computeEcKeyExchangePms();
            } else {
                LOGGER.warn("KEX with {} not Implemented. Using new byte[0] as PMS", (Object)certificateKeyType.name());
                this.premasterSecret = new byte[0];
            }
        } else {
            this.premasterSecret = new byte[0];
        }
        this.preparePremasterSecret(this.msg);
    }

    public void computeDhKeyExchangePms() {
        BigInteger modulus = this.chooser.getDhKeyExchangeModulus();
        ((EmptyClientKeyExchangeMessage)this.msg).getComputations().setDhModulus(modulus);
        BigInteger publicKey = this.chooser.getDhKeyExchangePeerPublicKey();
        ((EmptyClientKeyExchangeMessage)this.msg).getComputations().setDhPeerPublicKey(publicKey);
        BigInteger privateKey = this.chooser.getDhKeyExchangePrivateKey();
        ((EmptyClientKeyExchangeMessage)this.msg).getComputations().setPrivateKey(privateKey);
        this.premasterSecret = this.calculateDhPremasterSecret((BigInteger)((EmptyClientKeyExchangeMessage)this.msg).getComputations().getDhModulus().getValue(), (BigInteger)((EmptyClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue(), (BigInteger)((EmptyClientKeyExchangeMessage)this.msg).getComputations().getDhPeerPublicKey().getValue());
    }

    public void computeEcKeyExchangePms() {
        EllipticCurve curve;
        NamedGroup usedGroup = this.chooser.getSelectedNamedGroup();
        LOGGER.debug("PMS used Group: {}", (Object)usedGroup.name());
        CyclicGroup group = usedGroup.getGroupParameters().getGroup();
        if (group instanceof EllipticCurve) {
            curve = (EllipticCurve)group;
        } else {
            LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
            curve = new EllipticCurveSECP256R1();
        }
        Point publicKey = this.chooser.getEcKeyExchangePeerPublicKey();
        ((EmptyClientKeyExchangeMessage)this.msg).getComputations().setEcPublicKeyX(publicKey.getFieldX().getData());
        ((EmptyClientKeyExchangeMessage)this.msg).getComputations().setEcPublicKeyY(publicKey.getFieldY().getData());
        publicKey = curve.getPoint((BigInteger)((EmptyClientKeyExchangeMessage)this.msg).getComputations().getEcPublicKeyX().getValue(), (BigInteger)((EmptyClientKeyExchangeMessage)this.msg).getComputations().getEcPublicKeyY().getValue());
        ((EmptyClientKeyExchangeMessage)this.msg).getComputations().setPrivateKey(this.chooser.getEcKeyExchangePrivateKey());
        BigInteger privateKey = (BigInteger)((EmptyClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue();
        this.premasterSecret = this.computeECPremasterSecret(curve, publicKey, privateKey);
    }
}

